//DS1302 //////////////////////////////////////////
#include <DS1302.h>
DS1302 rtc(7, 6, 5);
Time t;
DS1302_RAM ramBuffer;

//L298N ///////////////////////////////////////////

// le numéro de la broche ou est branché la sortie IN1 du L298N
int IN1 = 10;
// le numéro de la broche ou est branché la sortie IN2 du L298N
int IN2 = 11;

//LCD I2C /////////////////////////////////////////
#include <Wire.h>
#include <LiquidCrystal_I2C.h>
LiquidCrystal_I2C lcd(0x27, 20, 4);

//Gestion des entrées /////////////////////////////
int Bthaut = A1;       //Pin du Bouton fleche haut
int Btbas = A2;        //Pin du Bouton fleche bas
int Btselect = A3;     //Pin du Bouton select
const int LDR = A0;    //Pin du LDR
const int fdchaut = 3; //Pin du fin de course haut
const int fdcbas = 4;  //Pin du fin de course bas

//Gestion des timers //////////////////////////////
unsigned long timerarduino;
unsigned long previousTime = 0;
unsigned long previousTimer1 = 0;
unsigned long Timer1;
unsigned long Timer1ON = 500;  // Tps clignotement pendant saisie
unsigned long Timer1OFF = 500; // Tps clignotement pendant saisie
bool Timer1Etat;
unsigned long previousTimer2 = 0;
unsigned long Timer2;
unsigned long Timer2ON = 60000; // Utiliser pour decompte pour hysterisis
unsigned long previousTimer3 = 0;
unsigned long Timer3;
unsigned long Timer3ON = 1000; // Utiliser pour decompte pour hysterisis
unsigned long previousTimer4 = 0;
unsigned long Timer4;
unsigned long Timer4ON; // Utiliser pour la mise en veille
unsigned long previousTimer5 = 0;
unsigned long Timer5;
unsigned long Timer5ON = 2000; // Utiliser pour la saisie rapide
unsigned long previousTimer6 = 0;
unsigned long Timer6;
unsigned long Timer6ON = 500; // Utiliser pour la saisie rapide
int TpsAvouverture;
int TpsAvfermeture;
unsigned long TpsAvouverturesec;
unsigned long TpsAvfermeturesec;

//Variable Menu ///////////////////////////////////
int Accueil = 1;       // Ecran Accueil
int Menu;              // Menu Principal
int MenuMdm;           // Menu Mode de Marche
int MenuPara;          // Menu parametres
int MenuParaProg;      // Menu parametres programmateur
int ParaProgHouv;      // Menu parametrage Progr Heure ouverture
int ParaProgHferm;     // Menu parametrage Progr Heure fermeture
int MenuParaLDR;       // Menu parametres LDR
int ParaLDRouv;        // Menu parametrage LDR ouverture
int ParaLDRferm;       // Menu parametrage LDR fermeture
int ParaLDRhysteresis; // Menu parametrage LDR Hysteresis
int MenuSyst;          // Menu systeme
int MenuSystVeille;    // Menu systeme veille
int SystVeilleetat;    // Menu systeme veille etat
int SystVeilleTpsactiv;// Menu systeme veille tps activation
int SystReglheure;     // Menu systeme Reglage Heure


//Variables programme/////////////////////////////
boolean RefreshAffHeure;
boolean RefreshAffEtatTrappeManu;
int Thour;
int Tmin;
int Tsec;
boolean EtatBtselect;
boolean EtatBthaut ;
boolean EtatBtbas;
boolean Etattrappe = 0;
boolean Saisierapide;
boolean Pause;         //Permet de mettre en pause certain affichage temps que moteur activer
int Modedemarche = 1;  //Defini mode de marche (1 = Progr, 2 = LDR, 3 = Manu)
long V_MinOuv = 23;    //Stock valeur Minute pour Progr Minute ouverture
long V_HeureOuv = 11;  //Stock valeur Heure pour Progr Heure ouverture
long V_MinFerm = 23;   //Stock valeur Minute pour Progr Minute fermeture
long V_HeureFerm = 23; //Stock valeur Heure pour Progr Heure fermeture
int V_LDRouv = 800;    //Stock valeur LDR pour ouverture
int V_LDRferm = 700;   //Stock valeur LDR pour fermeture
int V_Hysteresis = 20; //Stock valeur LDR pour Hysterisis
int V_Tsystheure;      //Stock la valeur dans systeme Reglage heure avant SAV
int V_Tsystminute;     //Stock la valeur dans systeme Reglage minute avant SAV
int V_Tsystseconde;    //Stock la valeur dans systeme Reglage seconde avant SAV
int Veille = 0;        // Ecran mise en veille
boolean Etatveille = 0;//Stock etat de la veille (actif ou inactif)
int V_TpsAvveille = 5; //Stock la valeur tps avant mise en veille en sec

byte customChar1[] = {B00000, B00000, B00001, B00001, B00001, B10110, B11000, B10000};
byte customChar2[] = {B00000, B11000, B00100, B10100, B00110, B01000, B00100, B00100};
byte customChar3[] = {B01000, B00111, B00001, B00011, B00000, B00000, B00000, B00000};
byte customChar4[] = {B01000, B10000, B10000, B11000, B00000, B00000, B00000, B00000};

void setup()
{
  Serial.begin(9600);
  //DS1302 //////////////////////////////////////////
  rtc.halt(false);
  // Réglez l'horloge en mode exécution et désactivez la protection en écriture
  rtc.writeProtect(true);
  rtc.setDOW(FRIDAY);        // Set Day-of-Week to FRIDAY
  rtc.setTime(19, 03, 0);     // Set the time to 12:00:00 (24hr format)
  rtc.setDate(22, 8, 2021);   // Set the date to August 6th, 2010
  //LCD I2C /////////////////////////////////////////
  lcd.init(); lcd.backlight();
  lcd.createChar(1, customChar1); lcd.createChar(2, customChar2);
  lcd.createChar(3, customChar3); lcd.createChar(4, customChar4);
  //Declaration des entrées /////////////////////////
  pinMode(Bthaut, INPUT_PULLUP);
  pinMode(Btbas, INPUT_PULLUP);
  pinMode(Btselect, INPUT_PULLUP);
  pinMode(fdchaut, INPUT_PULLUP);
  pinMode(fdcbas, INPUT_PULLUP);
  //L298N ///////////////////////////////////////////
  pinMode(IN1, OUTPUT);
  pinMode(IN2, OUTPUT);
  //Lecture et Récupération des valeurs de réglages dans RAM DS1302
  ramBuffer = rtc.readBuffer();
  Serial.println("Lecture de la RAM : ");
  for (int i = 0; i < 31; i++)
  {
    Serial.print(" "); Serial.print(ramBuffer.cell[i]); Serial.print(" ");
  }
  Serial.println(" ");
  LoadSav();
  //Intro ///////////////////////////////////////////
  Intro();
}

void loop()
{
  int valeurLDR = analogRead(LDR);
  timerarduino = millis();
  //Ecran Accueil ///////////////////////////////////
  switch (Accueil) {
    case 0:
      break;
    case 1:
      lcd.clear(); Accueil++;
      break;
    case 2:
      lcd.setCursor(0, 1); lcd.print("Mode :");
      lcd.setCursor(0, 2); lcd.print("Trappe :");
      Accueil++;
      break;
    case 3:
      if (Modedemarche == 1) {
        Accueil = 4 ; RefreshAffHeure = 0;
      }
      else if (Modedemarche == 2) {
        Accueil = 5; RefreshAffHeure = 0;
      }
      else if (Modedemarche == 3) {
        Accueil = 6; RefreshAffHeure = 0;
      }
      break;
    case 4:
      lcd.setCursor(7, 1); lcd.print("Programmateur");
      lcd.setCursor(0, 3); lcd.print("Ouv ");
      if (V_HeureOuv < 10) {
        lcd.setCursor(4, 3); lcd.print("0");
        lcd.setCursor(5, 3); lcd.print(V_HeureOuv);
      }
      else {
        lcd.setCursor(4, 3); lcd.print(V_HeureOuv);
      }
      lcd.setCursor(6, 3); lcd.print(":");
      if (V_MinOuv < 10) {
        lcd.setCursor(7, 3); lcd.print("0");
        lcd.setCursor(8, 3); lcd.print(V_MinOuv);
      }
      else {
        lcd.setCursor(7, 3);
        lcd.print(V_MinOuv);
      }
      lcd.setCursor(11, 3); lcd.print("Fer");
      if (V_HeureFerm < 10) {
        lcd.setCursor(15, 3); lcd.print("0");
        lcd.setCursor(16, 3); lcd.print(V_HeureFerm);
      }
      else {
        lcd.setCursor(15, 3);
        lcd.print(V_HeureFerm);
      }
      lcd.setCursor(17, 3); lcd.print(":");
      if (V_MinFerm < 10) {
        lcd.setCursor(18, 3); lcd.print("0");
        lcd.setCursor(19, 3); lcd.print(V_MinFerm);
      }
      else {
        lcd.setCursor(18, 3); lcd.print(V_MinFerm);
      }
      Accueil = 7;
      break;
    case 5:
      lcd.setCursor(7, 1); lcd.print("LDR");
      lcd.setCursor(0, 3); lcd.print("Ouv.: ");
      lcd.setCursor(6, 3); lcd.print(V_LDRouv);
      lcd.setCursor(11, 3); lcd.print("Fer.: ");
      lcd.setCursor(17, 3); lcd.print(V_LDRferm);
      Accueil = 7;
      break;
    case 6:
      lcd.setCursor(7, 1); lcd.print("Manuel");
      Accueil = 7;
      break;
    case 7:
      if (Modedemarche == 2) {
        if (Pause == 0) {
          AffValeurLDR(valeurLDR); AffEtatTrappeLDR();
        }
        GestionTrappeLDR(); GestionTrappeAuto(); EcrVeille();
      }
      if (Modedemarche == 1) {
        if (Pause == 0) {
          GestionTrappeProg(); AffEtatTrappeProg();
        }
        GestionTrappeAuto(); EcrVeille();
      }
      if (Modedemarche == 3) {
        GestionTrappeManu(); AffEtatTrappeManu(); EcrVeille();
      }
      AffHeure();
      break;
    default:
      break;
  }

  //Menu principal///////////////////////////////////
  switch (Menu) {
    case 0:
      break;
    case 1:
      lcd.clear(); Menu++;
      break;
    case 2:
      lcd.setCursor(0, 0); lcd.print("------- Menu -------");
      lcd.setCursor(0, 1); lcd.print("Mode de marche");
      lcd.setCursor(0, 2); lcd.print("Parametres");
      lcd.setCursor(0, 3); lcd.print("Systeme");
      Menu++;
      break;
    case 3:
      lcd.setCursor(19, 3); lcd.print(" ");
      lcd.setCursor(19, 1); lcd.print("<");
      lcd.setCursor(19, 2); lcd.print(" ");
      break;
    case 4:
      lcd.setCursor(19, 1); lcd.print(" ");
      lcd.setCursor(19, 2); lcd.print("<");
      lcd.setCursor(19, 3); lcd.print(" ");
      break;
    case 5:
      lcd.setCursor(19, 2); lcd.print(" ");
      lcd.setCursor(19, 3); lcd.print("<");
      lcd.setCursor(19, 1);
      lcd.print (" ");
      break;
    case 6:
      lcd.clear(); Menu = 8;
      break;
    case 7:
      lcd.setCursor(0, 0); lcd.print("------- Menu -------");
      lcd.setCursor(0, 1); lcd.print("Mode de marche");
      lcd.setCursor(0, 2); lcd.print("Parametres");
      lcd.setCursor(0, 3); lcd.print("Systeme");
      Menu = 5;
      break;
    case 8:
      lcd.clear(); Menu++;
      break;
    case 9:
      lcd.setCursor(0, 0); lcd.print("------- Menu -------");
      lcd.setCursor(0, 1); lcd.print("Retour");
      Menu = 11;
      break;
    case 10:
      Menu = 7;
      break;
    case 11:
      lcd.setCursor(19, 3); lcd.print(" ");
      lcd.setCursor(19, 1); lcd.print("<");
      lcd.setCursor(19, 2); lcd.print(" ");
      break;
    default:
      break;
  }

  //Menu mode de marche//////////////////////////////
  switch (MenuMdm) {
    case 0:
      break;
    case 1:
      lcd.clear(); MenuMdm++;
      break;
    case 2:
      lcd.setCursor(0, 0); lcd.print("-- Mode de marche --");
      lcd.setCursor(0, 1); lcd.print("Programmateur");
      lcd.setCursor(0, 2); lcd.print("LDR");
      lcd.setCursor(0, 3); lcd.print("Manuel");
      MenuMdm++;
      break;
    case 3:
      lcd.setCursor(19, 3); lcd.print(" ");
      lcd.setCursor(19, 1); lcd.print("<");
      lcd.setCursor(19, 2); lcd.print(" ");
      break;
    case 4:
      lcd.setCursor(19, 1); lcd.print(" ");
      lcd.setCursor(19, 2); lcd.print("<");
      lcd.setCursor(19, 3); lcd.print(" ");
      break;
    case 5:
      lcd.setCursor(19, 2); lcd.print(" ");
      lcd.setCursor(19, 3); lcd.print("<");
      lcd.setCursor(19, 1); lcd.print(" ");
      break;
    case 6:
      lcd.clear();
      MenuMdm = 8;
      break;
    case 7:
      lcd.setCursor(0, 0); lcd.print("-- Mode de marche --");
      lcd.setCursor(0, 1); lcd.print("Programmateur");
      lcd.setCursor(0, 2); lcd.print("LDR");
      lcd.setCursor(0, 3); lcd.print("Manuel");
      MenuMdm = 5;
      break;
    case 8:
      lcd.clear();
      MenuMdm++;
      break;
    case 9:
      lcd.setCursor(0, 0); lcd.print("-- Mode de marche --");
      lcd.setCursor(0, 1); lcd.print("Retour");
      MenuMdm = 11;
      break;
    case 10:
      MenuMdm = 7;
      break;
    case 11:
      lcd.setCursor(19, 3); lcd.print(" ");
      lcd.setCursor(19, 1); lcd.print("<");
      lcd.setCursor(19, 2); lcd.print(" ");
      break;
    default:
      break;
  }

  //Menu parametres /////////////////////////////////
  switch (MenuPara) {
    case 0:
      break;
    case 1:
      lcd.clear(); MenuPara++;
      break;
    case 2:
      lcd.setCursor(0, 0); lcd.print("---- Parametres ----");
      lcd.setCursor(0, 1); lcd.print("Programmateur");
      lcd.setCursor(0, 2); lcd.print("LDR");
      lcd.setCursor(0, 3); lcd.print("Retour");
      MenuPara++;
      break;
    case 3:
      lcd.setCursor(19, 3); lcd.print(" ");
      lcd.setCursor(19, 1); lcd.print("<");
      lcd.setCursor(19, 2); lcd.print(" ");
      break;
    case 4:
      lcd.setCursor(19, 1); lcd.print(" ");
      lcd.setCursor(19, 2); lcd.print("<");
      lcd.setCursor(19, 3); lcd.print(" ");
      break;
    case 5:
      lcd.setCursor(19, 2); lcd.print(" ");
      lcd.setCursor(19, 3); lcd.print("<");
      lcd.setCursor(19, 1); lcd.print(" ");
      break;
    default:
      break;
  }

  //Menu Parametres programmateur////////////////////
  switch (MenuParaProg) {
    case 0:
      break;
    case 1:
      lcd.clear(); MenuParaProg++;
      break;
    case 2:
      lcd.setCursor(0, 0); lcd.print("-- Programmateur ---");
      lcd.setCursor(0, 1); lcd.print("Heure ouverture");
      lcd.setCursor(0, 2); lcd.print("Heure fermeture");
      lcd.setCursor(0, 3); lcd.print("Retour");
      MenuParaProg++;
      break;
    case 3:
      lcd.setCursor(19, 3); lcd.print(" ");
      lcd.setCursor(19, 1); lcd.print("<");
      lcd.setCursor(19, 2); lcd.print(" ");
      break;
    case 4:
      lcd.setCursor(19, 1); lcd.print(" ");
      lcd.setCursor(19, 2); lcd.print("<");
      lcd.setCursor(19, 3); lcd.print(" ");
      break;
    case 5:
      lcd.setCursor(19, 2); lcd.print(" ");
      lcd.setCursor(19, 3); lcd.print("<");
      lcd.setCursor(19, 1); lcd.print(" ");
      break;
    default:
      break;
  }

  //Menu parametrage Progr Heure ouverture///////////
  switch (ParaProgHouv) {
    case 0:
      break;
    case 1:
      lcd.clear(); ParaProgHouv++;
      break;
    case 2:
      lcd.setCursor(0, 0); lcd.print("- Heure ouverture --");
      lcd.setCursor(9, 2); lcd.print(":");
      if (V_MinOuv < 10) {
        lcd.setCursor(10, 2); lcd.print("0");
        lcd.setCursor(11, 2); lcd.print(V_MinOuv);
      }
      else {
        lcd.setCursor(10, 2); lcd.print(V_MinOuv);
      }
      ParaProgHouv++;
      break;
    case 3:
      if (Timer1Etat) {
        Timer1 = Timer1OFF;
      }
      else {
        Timer1 = Timer1ON;
      }
      if ((timerarduino - previousTimer1) > Timer1) {
        previousTimer1 = timerarduino;
        Timer1Etat = !Timer1Etat;
        if (Timer1Etat) {
          if (V_HeureOuv < 10) {
            lcd.setCursor(7, 2); lcd.print("0");
            lcd.setCursor(8, 2); lcd.print(V_HeureOuv);
          }
          else {
            lcd.setCursor(7, 2); lcd.print(V_HeureOuv);
          }
        }
        else {
          lcd.setCursor(7, 2); lcd.print("  ");
        }
      }
      break;
    case 4:
      if (V_HeureOuv < 10) {
        lcd.setCursor(7, 2); lcd.print("0");
        lcd.setCursor(8, 2); lcd.print(V_HeureOuv);
      }
      else {
        lcd.setCursor(7, 2); lcd.print(V_HeureOuv);
      }
      previousTimer1 = timerarduino;
      ParaProgHouv++;
      break;
    case 5:
      if (Timer1Etat) {
        Timer1 = Timer1OFF;
      } else {
        Timer1 = Timer1ON;
      }
      if ((timerarduino - previousTimer1) > Timer1) {
        previousTimer1 = timerarduino;
        Timer1Etat = !Timer1Etat;
        if (Timer1Etat) {
          if (V_MinOuv < 10) {
            lcd.setCursor(10, 2); lcd.print("0");
            lcd.setCursor(11, 2); lcd.print(V_MinOuv);
          }
          else {
            lcd.setCursor(10, 2); lcd.print(V_MinOuv);
          }
        }
        else {
          lcd.setCursor(10, 2); lcd.print("  ");
        }
      }
      break;
    default:
      break;
  }

  //Menu parametrage Progr Heure fermeture///////////
  switch (ParaProgHferm) {
    case 0:
      break;
    case 1:
      lcd.clear(); ParaProgHferm++;
      break;
    case 2:
      lcd.setCursor(0, 0); lcd.print("- Heure fermeture --");
      lcd.setCursor(9, 2); lcd.print(":");
      if (V_MinFerm < 10) {
        lcd.setCursor(10, 2); lcd.print("0");
        lcd.setCursor(11, 2); lcd.print(V_MinFerm);
      }
      else {
        lcd.setCursor(10, 2); lcd.print(V_MinFerm);
      }
      ParaProgHferm++;
      break;
    case 3:
      if (Timer1Etat) {
        Timer1 = Timer1OFF;
      }
      else {
        Timer1 = Timer1ON;
      }
      if ((timerarduino - previousTimer1) > Timer1) {
        previousTimer1 = timerarduino;
        Timer1Etat = !Timer1Etat;
        if (Timer1Etat) {
          if (V_HeureFerm < 10) {
            lcd.setCursor(7, 2); lcd.print("0");
            lcd.setCursor(8, 2); lcd.print(V_HeureFerm);
          }
          else {
            lcd.setCursor(7, 2); lcd.print(V_HeureFerm);
          }
        }
        else {
          lcd.setCursor(7, 2); lcd.print("  ");
        }
      }
      break;
    case 4:
      if (V_HeureFerm < 10) {
        lcd.setCursor(7, 2); lcd.print("0");
        lcd.setCursor(8, 2); lcd.print(V_HeureFerm);
      }
      else {
        lcd.setCursor(7, 2); lcd.print(V_HeureFerm);
      }
      ParaProgHferm++;
      break;
    case 5:
      if (Timer1Etat) {
        Timer1 = Timer1OFF;
      }
      else {
        Timer1 = Timer1ON;
      }
      if ((timerarduino - previousTimer1) > Timer1) {
        previousTimer1 = timerarduino;
        Timer1Etat = !Timer1Etat;
        if (Timer1Etat) {
          if (V_MinFerm < 10) {
            lcd.setCursor(10, 2); lcd.print("0");
            lcd.setCursor(11, 2); lcd.print(V_MinFerm);
          }
          else {
            lcd.setCursor(10, 2); lcd.print(V_MinFerm);
          }
        }
        else {
          lcd.setCursor(10, 2); lcd.print("  ");
        }
      }
      break;
    case 6:
      break;
    default:
      break;
  }

  //Menu parametres LDR /////////////////////////////
  switch (MenuParaLDR) {
    case 0:
      break;
    case 1:
      lcd.clear(); MenuParaLDR++;
      break;
    case 2:
      lcd.setCursor(0, 0); lcd.print("------- LDR --------");
      lcd.setCursor(0, 1); lcd.print("Valeur ouverture");
      lcd.setCursor(0, 2); lcd.print("Valeur fermeture");
      lcd.setCursor(0, 3); lcd.print("Hysteresis");
      MenuParaLDR++;
      break;
    case 3:
      lcd.setCursor(19, 3); lcd.print(" ");
      lcd.setCursor(19, 1); lcd.print("<");
      lcd.setCursor(19, 2); lcd.print(" ");
      break;
    case 4:
      lcd.setCursor(19, 1); lcd.print(" ");
      lcd.setCursor(19, 2); lcd.print("<");
      lcd.setCursor(19, 3); lcd.print(" ");
      break;
    case 5:
      lcd.setCursor(19, 2); lcd.print(" ");
      lcd.setCursor(19, 3); lcd.print("<");
      lcd.setCursor(19, 1); lcd.print(" ");
      break;
    case 6:
      lcd.clear();
      MenuParaLDR = 8;
      break;
    case 7:
      lcd.setCursor(0, 0); lcd.print("------- LDR --------");
      lcd.setCursor(0, 1); lcd.print("Valeur ouverture");
      lcd.setCursor(0, 2); lcd.print("Valeur fermeture");
      lcd.setCursor(0, 3); lcd.print("Hysteresis");
      MenuParaLDR = 5;
      break;
    case 8:
      lcd.clear();
      MenuParaLDR++;
      break;
    case 9:
      lcd.setCursor(0, 0); lcd.print("------- LDR --------");
      lcd.setCursor(0, 1); lcd.print("Retour");
      MenuParaLDR = 11;
      break;
    case 10:
      MenuParaLDR = 7;
      break;
    case 11:
      lcd.setCursor(19, 3); lcd.print(" ");
      lcd.setCursor(19, 1); lcd.print("<");
      lcd.setCursor(19, 2); lcd.print(" ");
      break;
    default:
      break;
  }

  //Menu parametrage LDR ouverture///////////////////
  switch (ParaLDRouv) {
    case 0:
      break;
    case 1:
      lcd.clear(); ParaLDRouv++;
      break;
    case 2:
      lcd.setCursor(0, 0); lcd.print("-- LDR ouverture ---");
      ParaLDRouv++;
      break;
    case 3:
      if (Timer1Etat) {
        Timer1 = Timer1OFF;
      }
      else {
        Timer1 = Timer1ON;
      }
      if ((timerarduino - previousTimer1) > Timer1) {
        previousTimer1 = timerarduino;
        Timer1Etat = !Timer1Etat;
        if (Timer1Etat || Saisierapide) {
          if (V_LDRouv < 100 && V_LDRouv > 9) {
            lcd.setCursor(8, 2); lcd.print(" ");
            lcd.setCursor(9, 2); lcd.print(V_LDRouv);
          }
          else if (V_LDRouv < 10) {
            lcd.setCursor(8, 2); lcd.print("  ");
            lcd.setCursor(10, 2); lcd.print(V_LDRouv);
          }
          else {
            lcd.setCursor(8, 2); lcd.print(V_LDRouv);
          }
        }
        else {
          lcd.setCursor(8, 2); lcd.print("   ");
        }
      }
      break;
    default:
      break;
  }

  //Menu parametrage LDR fermeture //////////////////
  switch (ParaLDRferm) {
    case 0:
      break;
    case 1:
      lcd.clear(); ParaLDRferm++;
      break;
    case 2:
      lcd.setCursor(0, 0); lcd.print("-- LDR fermeture ---");
      ParaLDRferm++;
      break;
    case 3:
      if (Timer1Etat) {
        Timer1 = Timer1OFF;
      }
      else {
        Timer1 = Timer1ON;
      }
      if ((timerarduino - previousTimer1) > Timer1) {
        previousTimer1 = timerarduino; Timer1Etat = !Timer1Etat;
        if (Timer1Etat || Saisierapide) {
          if (V_LDRferm < 100 && V_LDRferm > 9) {
            lcd.setCursor(8, 2); lcd.print(" ");
            lcd.setCursor(9, 2); lcd.print(V_LDRferm);
          }
          else if (V_LDRferm < 10) {
            lcd.setCursor(8, 2); lcd.print("  ");
            lcd.setCursor(10, 2); lcd.print(V_LDRferm);
          }
          else {
            lcd.setCursor(8, 2); lcd.print(V_LDRferm);
          }
        }
        else {
          lcd.setCursor(8, 2); lcd.print("   ");
        }
      }
      break;
    default:
      break;
  }

  //Menu parametrage LDR Hysteresis /////////////////
  switch (ParaLDRhysteresis) {
    case 0:
      break;
    case 1:
      lcd.clear(); ParaLDRhysteresis++;
      break;
    case 2:
      lcd.setCursor(0, 0); lcd.print ("-- LDR hysteresis --");
      lcd.setCursor(11, 2); lcd.print ("min");
      ParaLDRhysteresis++;
      break;
    case 3:
      if (Timer1Etat) {
        Timer1 = Timer1OFF;
      } else {
        Timer1 = Timer1ON;
      }
      if ((timerarduino - previousTimer1) > Timer1) {
        previousTimer1 = timerarduino;
        Timer1Etat = !Timer1Etat;
        if (Timer1Etat || Saisierapide) {
          if (V_Hysteresis < 100 && V_Hysteresis > 9) {
            lcd.setCursor(7, 2); lcd.print(" ");
            lcd.setCursor(8, 2); lcd.print(V_Hysteresis);
          }
          else if (V_Hysteresis < 10) {
            lcd.setCursor(7, 2); lcd.print("  ");
            lcd.setCursor(9, 2); lcd.print(V_Hysteresis);
          }
          else {
            lcd.setCursor(7, 2); lcd.print(V_Hysteresis);
          }
        }
        else {
          lcd.setCursor(7, 2); lcd.print("   ");
        }
      }
      break;
    default:
      break;
  }

  //Menu Systeme ////////////////////////////////////
  switch (MenuSyst) {
    case 0:
      break;
    case 1:
      lcd.clear(); MenuSyst++;
      break;
    case 2:
      lcd.setCursor(0, 0); lcd.print("----- Systeme ------");
      lcd.setCursor(0, 1); lcd.print("Reglage heure");
      lcd.setCursor(0, 2); lcd.print("Gest. Veille");
      lcd.setCursor(0, 3); lcd.print("Retour");
      MenuSyst++;
      break;
    case 3:
      lcd.setCursor(19, 3); lcd.print(" ");
      lcd.setCursor(19, 1); lcd.print("<");
      lcd.setCursor(19, 2); lcd.print (" ");
      break;
    case 4:
      lcd.setCursor(19, 1); lcd.print(" ");
      lcd.setCursor(19, 2); lcd.print("<");
      lcd.setCursor(19, 3); lcd.print(" ");
      break;
    case 5:
      lcd.setCursor(19, 2); lcd.print(" ");
      lcd.setCursor(19, 3); lcd.print("<");
      lcd.setCursor(19, 1); lcd.print(" ");
      break;
    default:
      break;
  }

  //Menu systeme Reglage Heure //////////////////////
  switch (SystReglheure) {
    case 0:
      break;
    case 1:
      lcd.clear();
      V_Tsystheure = t.hour; V_Tsystminute = t.min; V_Tsystseconde = t.sec;
      SystReglheure++;
      break;
    case 2:
      lcd.setCursor(0, 0); lcd.print("-- Heure systeme ---");
      lcd.setCursor(8, 2); lcd.print(":");
      if (V_Tsystminute < 10) {
        lcd.setCursor(9, 2); lcd.print("0");
        lcd.setCursor(10, 2); lcd.print(V_Tsystminute);
      }
      else {
        lcd.setCursor(9, 2); lcd.print(V_Tsystminute);
      }
      lcd.setCursor(11, 2); lcd.print(":");
      if (V_Tsystseconde < 10) {
        lcd.setCursor(12, 2); lcd.print("0");
        lcd.setCursor(13, 2); lcd.print(V_Tsystseconde);
      }
      else {
        lcd.setCursor(12, 2); lcd.print(V_Tsystseconde);
      }
      SystReglheure++;
      break;
    case 3:
      if (Timer1Etat) {
        Timer1 = Timer1OFF;
      } else {
        Timer1 = Timer1ON;
      }
      if ((timerarduino - previousTimer1) > Timer1) {
        previousTimer1 = timerarduino;
        Timer1Etat = !Timer1Etat;
        if (Timer1Etat) {
          if (V_Tsystheure < 10) {
            lcd.setCursor(6, 2); lcd.print("0");
            lcd.setCursor(7, 2); lcd.print(V_Tsystheure);
          }
          else {
            lcd.setCursor(6, 2); lcd.print(V_Tsystheure);
          }
        }
        else {
          lcd.setCursor(6, 2); lcd.print("  ");
        }
      }
      break;
    case 4:
      if (V_Tsystheure < 10) {
        lcd.setCursor(6, 2); lcd.print("0");
        lcd.setCursor(7, 2); lcd.print(V_Tsystheure);
      }
      else {
        lcd.setCursor(6, 2); lcd.print(V_Tsystheure);
      }
      SystReglheure++;
      break;
    case 5:
      if (Timer1Etat) {
        Timer1 = Timer1OFF;
      } else {
        Timer1 = Timer1ON;
      }
      if ((timerarduino - previousTimer1) > Timer1) {
        previousTimer1 = timerarduino;
        Timer1Etat = !Timer1Etat;
        if (Timer1Etat) {
          if (V_Tsystminute < 10) {
            lcd.setCursor(9, 2); lcd.print("0");
            lcd.setCursor(10, 2); lcd.print(V_Tsystminute);
          }
          else {
            lcd.setCursor(9, 2); lcd.print(V_Tsystminute);
          }
        }
        else {
          lcd.setCursor(9, 2); lcd.print("  ");
        }
      }
      break;
    case 6:
      if (V_Tsystminute < 10) {
        lcd.setCursor(9, 2); lcd.print("0");
        lcd.setCursor(10, 2); lcd.print(V_Tsystminute);
      }
      else {
        lcd.setCursor(9, 2); lcd.print(V_Tsystminute);
      }
      SystReglheure++;
      break;
    case 7:
      if (Timer1Etat) {
        Timer1 = Timer1OFF;
      } else {
        Timer1 = Timer1ON;
      }
      if ((timerarduino - previousTimer1) > Timer1) {
        previousTimer1 = timerarduino;
        Timer1Etat = !Timer1Etat;
        if (Timer1Etat) {
          if (V_Tsystseconde < 10) {
            lcd.setCursor(12, 2); lcd.print("0");
            lcd.setCursor(13, 2); lcd.print(V_Tsystseconde);
          }
          else {
            lcd.setCursor(12, 2); lcd.print(V_Tsystseconde);
          }
        }
        else {
          lcd.setCursor(12, 2); lcd.print("  ");
        }
      }
      break;
    default:
      break;
  }

  //Menu systeme veille /////////////////////////////
  switch (MenuSystVeille) {
    case 0:
      break;
    case 1:
      lcd.clear(); MenuSystVeille++;
      break;
    case 2:
      lcd.setCursor(0, 0); lcd.print("----- Veille  ------");
      lcd.setCursor(0, 1); lcd.print("Etat");
      lcd.setCursor(0, 2); lcd.print("Tps av. activation");
      lcd.setCursor(0, 3); lcd.print("Retour");
      MenuSystVeille++;
      break;
    case 3:
      lcd.setCursor(19, 3); lcd.print(" ");
      lcd.setCursor(19, 1); lcd.print("<");
      lcd.setCursor(19, 2); lcd.print(" ");
      break;
    case 4:
      lcd.setCursor(19, 1); lcd.print(" ");
      lcd.setCursor(19, 2); lcd.print("<");
      lcd.setCursor(19, 3); lcd.print(" ");
      break;
    case 5:
      lcd.setCursor(19, 2); lcd.print(" ");
      lcd.setCursor(19, 3); lcd.print("<");
      lcd.setCursor(19, 1); lcd.print(" ");
      break;
    default:
      break;
  }

  //Menu systeme veille etat //////////////////
  switch (SystVeilleetat) {
    case 0:
      break;
    case 1:
      lcd.clear(); SystVeilleetat++;
      break;
    case 2:
      lcd.setCursor(0, 0); lcd.print("--- Veille Etat ----");
      SystVeilleetat++;
      break;
    case 3:
      if (Timer1Etat) {
        Timer1 = Timer1OFF;
      }
      else {
        Timer1 = Timer1ON;
      }
      if ((timerarduino - previousTimer1) > Timer1) {
        previousTimer1 = timerarduino; Timer1Etat = !Timer1Etat;
        if (Timer1Etat) {
          if (Etatveille) {
            lcd.setCursor(6, 2); lcd.print(" Actif ");
          }
          else {
            lcd.setCursor(6, 2); lcd.print("Inactif");
          }
        }
        else {
          lcd.setCursor(6, 2); lcd.print("       ");
        }
      }
      break;
    default:
      break;
  }
  //Menu systeme veille Tps av. activation //////////
  switch (SystVeilleTpsactiv) {
    case 0:
      break;
    case 1:
      lcd.clear(); SystVeilleTpsactiv++;
      break;
    case 2:
      lcd.setCursor(0, 0); lcd.print(" Tps av. Act Veille ");
      lcd.setCursor(11, 2); lcd.print("sec");
      SystVeilleTpsactiv++;
      break;
    case 3:
      if (Timer1Etat) {
        Timer1 = Timer1OFF;
      } else {
        Timer1 = Timer1ON;
      }
      if ((timerarduino - previousTimer1) > Timer1) {
        previousTimer1 = timerarduino;
        Timer1Etat = !Timer1Etat;
        if (Timer1Etat || Saisierapide) {
          if (V_TpsAvveille < 100 && V_TpsAvveille > 9) {
            lcd.setCursor(7, 2); lcd.print("  ");
            lcd.setCursor(8, 2); lcd.print(V_TpsAvveille);
          }
          else if (V_TpsAvveille < 10) {
            lcd.setCursor(7, 2); lcd.print("  ");
            lcd.setCursor(9, 2); lcd.print(V_TpsAvveille);
          }
          else {
            lcd.setCursor(7, 2); lcd.print(V_TpsAvveille);
          }
        }
        else {
          lcd.setCursor(7, 2); lcd.print ("   ");
        }
      }
      break;
    default:
      break;
  }
  ///////////////////////////////////////////////////

  //Gestion des boutons /////////////////////////////
  if (digitalRead(Bthaut) == LOW && EtatBthaut == 0) {
    EtatBthaut = 1; NavBthaut();
  }
  if (digitalRead(Btbas) == LOW && EtatBtbas == 0) {
    EtatBtbas = 1; NavBtbas();
  }
  if (digitalRead(Btselect) == LOW && EtatBtselect == 0) {
    EtatBtselect = 1; navmenuboutonselect();
  }
  if (digitalRead(Bthaut) == LOW && EtatBthaut == 1) {
    if ((timerarduino - previousTimer5) > Timer5ON) {
      NavBthautrapide(); Saisierapide = 1;
    }
  }
  if (digitalRead(Btbas) == LOW && EtatBtbas == 1) {
    if ((timerarduino - previousTimer5) > Timer5ON) {
      NavBtbasrapide(); Saisierapide = 1;
    }
  }
  if (digitalRead(Bthaut) == HIGH && digitalRead(Btbas) == HIGH) {
    previousTimer5 = timerarduino; Saisierapide = 0;
  }
  if (digitalRead(Bthaut) == HIGH) {
    EtatBthaut = 0;
  }
  if (digitalRead(Btbas) == HIGH) {
    EtatBtbas = 0;
  }
  if (digitalRead(Btselect) == HIGH) {
    EtatBtselect = 0;
  }
}

//Gestion de la Trappe par Programmateur //////////
void GestionTrappeProg() {
  unsigned long ouverturesec = (V_MinOuv * 60) + (V_HeureOuv * 3600);
  unsigned long fermeturesec = (V_MinFerm * 60) + (V_HeureFerm * 3600);
  t = rtc.getTime();
  long hour = t.hour; long min = t.min; long sec = t.sec;
  unsigned long heuresec = (min * 60) + (hour * 3600) + sec;
  if (ouverturesec < fermeturesec && Modedemarche == 1) {
    if (heuresec > ouverturesec && heuresec < fermeturesec) {
      Etattrappe = 1;
    }
    else {
      Etattrappe = 0;
    }
  }
  if (ouverturesec > fermeturesec && Modedemarche == 1) {
    if ((heuresec > ouverturesec && heuresec > fermeturesec) || (heuresec < ouverturesec && heuresec < fermeturesec)) {
      Etattrappe = 1;
    }
    if (heuresec > fermeturesec && heuresec < ouverturesec) {
      Etattrappe = 0;
    }
  }
}

//Gestion de la Trappe par le LDR /////////////////
void GestionTrappeLDR() {
  int valeurLDR = analogRead(LDR);
  if (valeurLDR > V_LDRouv && Etattrappe == 0 && Modedemarche == 2) {
    if (TpsAvouverture == 0 && TpsAvouverturesec == 0) {
      TpsAvouverture = V_Hysteresis; previousTimer2 = timerarduino;
      TpsAvouverturesec = V_Hysteresis * 60; previousTimer3 = timerarduino;
    }
    else {
      if ((timerarduino - previousTimer2) > Timer2ON) {
        previousTimer2 = timerarduino; TpsAvouverture--;
      }
      if ((timerarduino - previousTimer3) > Timer3ON) {
        previousTimer3 = timerarduino; TpsAvouverturesec--;
      }
    }
    if (TpsAvouverturesec == 0) {
      lcd.setCursor(9, 2); lcd.print("           ");
      Etattrappe = 1;
    }
  }
  else {
    TpsAvouverture = 0; TpsAvouverturesec = 0;
  }
  if (valeurLDR < V_LDRferm && Etattrappe == 1 && Modedemarche == 2) {
    if (TpsAvfermeture == 0 && TpsAvfermeturesec == 0) {
      TpsAvfermeture = V_Hysteresis; previousTimer2 = timerarduino;
      TpsAvfermeturesec = V_Hysteresis * 60; previousTimer3 = timerarduino;
    }
    else {
      if ((timerarduino - previousTimer2) > Timer2ON) {
        previousTimer2 = timerarduino; TpsAvfermeture--;
      }
      if ((timerarduino - previousTimer3) > Timer3ON) {
        previousTimer3 = timerarduino; TpsAvfermeturesec--;
      }
    }
    if (TpsAvfermeturesec == 0 ) {
      lcd.setCursor(9, 2); lcd.print("           ");
      Etattrappe = 0;
    }
  }
  else {
    TpsAvfermeture = 0; TpsAvfermeturesec = 0;
  }
}

//Affichage Etat Trappe en Mode Manu /////
void AffEtatTrappeManu() {
  if (digitalRead(Bthaut) == LOW && RefreshAffEtatTrappeManu == 0) {
    lcd.setCursor(9, 2); lcd.print("       ");
    RefreshAffEtatTrappeManu = 1;
  }
  if (digitalRead(Btbas) == LOW && RefreshAffEtatTrappeManu == 0) {
    lcd.setCursor(9, 2); lcd.print("       ");
    RefreshAffEtatTrappeManu = 1;
  }
  if (digitalRead(Bthaut) == HIGH && digitalRead(Btbas) == HIGH) {
    RefreshAffEtatTrappeManu = 0;
  }
  if (digitalRead(fdchaut) == LOW && digitalRead(Btbas) == HIGH) {
    lcd.setCursor(9, 2); lcd.print("Ouverte");
  }
  if (digitalRead(fdcbas) == LOW && digitalRead(Bthaut) == HIGH) {
    lcd.setCursor(9, 2); lcd.print("Fermer ");
  }
}

//Affichage Etat Trappe en Mode Programmateur /////
void AffEtatTrappeProg() {
  if (Etattrappe == 1 && digitalRead(fdchaut) == LOW) {
    lcd.setCursor(9, 2); lcd.print("Ouverte");
  }
  if (Etattrappe == 0 && digitalRead(fdcbas) == LOW) {
    lcd.setCursor(9, 2); lcd.print("Fermer ");
  }
}

//Affichage Etat Trappe en Mode LDR ///////////////
void AffEtatTrappeLDR() {
  if (TpsAvfermeturesec == 0 && TpsAvouverturesec == 0 && TpsAvouverture == 0 && Etattrappe == 1 && TpsAvfermeture == 0 && digitalRead(fdchaut) == LOW) {
    lcd.setCursor(9, 2); lcd.print("Ouverte    ");
  }
  if (TpsAvfermeturesec == 0 && TpsAvouverturesec == 0 && TpsAvfermeture == 0 && Etattrappe == 0 && TpsAvouverture == 0 && digitalRead(fdcbas) == LOW) {
    lcd.setCursor(9, 2);  lcd.print("Fermer     ");
  }
  if (TpsAvouverture > 1) {
    if (TpsAvouverture < 100 && TpsAvouverture > 9) {
      lcd.setCursor(9, 2); lcd.print(" ");
      lcd.setCursor(10, 2); lcd.print(TpsAvouverture);
    }
    else if (TpsAvouverture < 10) {
      lcd.setCursor(9, 2); lcd.print("  ");
      lcd.setCursor(11, 2); lcd.print(TpsAvouverture);
    }
    else {
      lcd.setCursor(9, 2); lcd.print(TpsAvouverture);
    }
    lcd.setCursor(12, 2); lcd.print("m AvOuv.");
  }
  if (TpsAvouverturesec < 60 && TpsAvouverturesec != 0) {
    if (TpsAvouverturesec < 100 && TpsAvouverturesec > 9) {
      lcd.setCursor(9, 2); lcd.print(" ");
      lcd.setCursor(10, 2); lcd.print(TpsAvouverturesec);
    }
    else if (TpsAvouverture < 10) {
      lcd.setCursor(9, 2); lcd.print("  ");
      lcd.setCursor(11, 2); lcd.print(TpsAvouverturesec);
    }
    else {
      lcd.setCursor(9, 2); lcd.print(TpsAvouverturesec);
    }
    lcd.setCursor(12, 2); lcd.print("s AvOuv.");
  }
  if (TpsAvfermeture > 1) {
    lcd.setCursor(0, 2); lcd.print("Trappe : ");
    if (TpsAvfermeture < 100 && TpsAvfermeture > 9) {
      lcd.setCursor(9, 2); lcd.print(" ");
      lcd.setCursor(10, 2); lcd.print(TpsAvfermeture);
    }
    else if (TpsAvfermeture < 10 && TpsAvfermeture > 0) {
      lcd.setCursor(9, 2); lcd.print("  ");
      lcd.setCursor(11, 2); lcd.print(TpsAvfermeture);
    }
    else if (TpsAvfermeture < 1) {
      lcd.setCursor(9, 2); lcd.print("            ");
    }
    else {
      lcd.setCursor(9, 2); lcd.print(TpsAvfermeture);
    }
    lcd.setCursor(12, 2);  lcd.print("m AvFer.");
  }
  if (TpsAvfermeturesec < 60 && TpsAvfermeturesec != 0) {
    if (TpsAvfermeturesec < 100 && TpsAvfermeturesec > 9) {
      lcd.setCursor(9, 2); lcd.print(" ");
      lcd.setCursor(10, 2); lcd.print(TpsAvfermeturesec);
    }
    else if (TpsAvfermeture < 10) {
      lcd.setCursor(9, 2); lcd.print("  ");
      lcd.setCursor(11, 2); lcd.print(TpsAvfermeturesec);
    }
    else {
      lcd.setCursor(9, 2); lcd.print(TpsAvfermeturesec);
    }
    lcd.setCursor(12, 2); lcd.print("s AvOuv.");
  }
}

//Affichage Valeur LDR ////////////////////////////
int AffValeurLDR (int valeurLDR) {
  if (valeurLDR < 1000 && valeurLDR > 99) {
    lcd.setCursor(16, 0); lcd.print(" ");
    lcd.setCursor(17, 0); lcd.print(valeurLDR);
  }
  else if (valeurLDR < 100 && valeurLDR > 9) {
    lcd.setCursor(16, 0); lcd.print("  ");
    lcd.setCursor(18, 0); lcd.print(valeurLDR);
  }
  else if (valeurLDR < 10) {
    lcd.setCursor(16, 0); lcd.print("   ");
    lcd.setCursor(19, 0); lcd.print(valeurLDR);
  }
  else {
    lcd.setCursor(16, 0); lcd.print(valeurLDR);
  }
}

//Affichage de l'heure ////////////////////////////
void AffHeure() {
  t = rtc.getTime();
  if (RefreshAffHeure == 0) {
    Thour = t.hour; Tmin = t.min; Tsec = t.sec;
    lcd.setCursor(2, 0); lcd.print(":");
    lcd.setCursor(5, 0); lcd.print(":");
  }

  if (Thour != t.hour || RefreshAffHeure == 0 ) {
    Thour = t.hour;
    if (t.hour < 10) {
      lcd.setCursor(0, 0); lcd.print("0");
      lcd.setCursor(1, 0); lcd.print(t.hour);
    }
    else {
      lcd.setCursor(0, 0); lcd.print(t.hour);
    }
  }
  if (Tmin != t.min || RefreshAffHeure == 0 ) {
    Tmin = t.min;
    if (t.min < 10) {
      lcd.setCursor(3, 0); lcd.print("0");
      lcd.setCursor(4, 0); lcd.print(t.min);
    }
    else {
      lcd.setCursor(3, 0); lcd.print(t.min);
    }
  }
  if (Tsec != t.sec || RefreshAffHeure == 0 ) {
    Tsec = t.sec;
    if (t.sec < 10) {
      lcd.setCursor(6, 0); lcd.print("0");
      lcd.setCursor(7, 0); lcd.print(t.sec);
    }
    else {
      lcd.setCursor(6, 0); lcd.print(t.sec);
    }
    RefreshAffHeure = 1;
  }
}

//Gestion de la Trappe en Mode Manu ///////////////
void GestionTrappeManu() {
  if (Modedemarche == 3 && Accueil == 7 && EtatBthaut == 1 && digitalRead(fdchaut) == HIGH) {
    Pause = 1; digitalWrite(IN1, 1); digitalWrite(IN2, 0);
  }
  else if (Modedemarche == 3 && Accueil == 7 && EtatBtbas == 1 && digitalRead(fdcbas) == HIGH) {
    Pause = 1; digitalWrite(IN1, 0); digitalWrite(IN2, 1);
  }
  else {
    Moteurrepos ();
    Pause = 0;
  }
  if (digitalRead(fdchaut) == LOW) {
    Etattrappe = 1;
  }
  if (digitalRead(fdcbas) == LOW) {
    Etattrappe = 0;
  }
}

//Gestion de la Trappe en Mode Auto ///////////////
void GestionTrappeAuto() {
  if ((Modedemarche == 1 || Modedemarche == 2) && Etattrappe == 1 && digitalRead(fdchaut) == HIGH) {
    Pause = 1; digitalWrite(IN1, 1); digitalWrite(IN2, 0);
  }
  else if ((Modedemarche == 1 || Modedemarche == 2) && Etattrappe == 0 && digitalRead(fdcbas) == HIGH) {
    Pause = 1; digitalWrite(IN1, 0); digitalWrite(IN2, 1);
  }
  else {
    Moteurrepos ();
    Pause = 0;
  }
}

//Mise au repos moteur PAP ////////////////////////
void Moteurrepos () {
  digitalWrite(IN1, 0);
  digitalWrite(IN2, 0);
}

//Sauvegarde Heures sur DS1302 ////////////////////
void SavHeure () {
  rtc.writeProtect(false);
  rtc.setTime(V_Tsystheure, V_Tsystminute, V_Tsystseconde);
  delay(50);
  rtc.writeProtect(true);
}

//Sauvegarde sur RAM DS1302 ///////////////////////
void Sav () {
  rtc.writeProtect(false);
  byte v_1LDRouverture = lowByte(V_LDRouv); byte v_2LDRouverture = highByte(V_LDRouv);
  byte v_1LDRfermeture = lowByte(V_LDRferm); byte v_2LDRfermeture = highByte(V_LDRferm);
  byte v_1LDRhysteresis = lowByte(V_Hysteresis); byte v_2LDRhysteresis = highByte(V_Hysteresis);
  byte v_1V_TpsAvveille = lowByte(V_TpsAvveille); byte v_2V_TpsAvveille = highByte(V_TpsAvveille);
  ramBuffer.cell[0] = 99; ramBuffer.cell[1] = Modedemarche;
  ramBuffer.cell[2] = V_HeureOuv; ramBuffer.cell[3] = V_MinOuv;
  ramBuffer.cell[4] = V_HeureFerm; ramBuffer.cell[5] = V_MinFerm;
  ramBuffer.cell[6] = v_1LDRouverture; ramBuffer.cell[7] = v_2LDRouverture;
  ramBuffer.cell[8] = v_1LDRfermeture; ramBuffer.cell[9] = v_2LDRfermeture;
  ramBuffer.cell[10] = v_1LDRhysteresis; ramBuffer.cell[11] = v_2LDRhysteresis;
  ramBuffer.cell[12] = Etattrappe; ramBuffer.cell[13] = Etatveille;
  ramBuffer.cell[14] = v_1V_TpsAvveille; ramBuffer.cell[15] = v_2V_TpsAvveille;

  rtc.writeBuffer(ramBuffer);
  ramBuffer = rtc.readBuffer();
  rtc.writeProtect(true);
  Serial.println("Sauvegarde sur RAM");
  for (int i = 0; i < 31; i++)
  {
    Serial.print(" "); Serial.print(ramBuffer.cell[i]); Serial.print(" ");
  }
  Serial.println(" ");
}

//Chargement de la RAM DS1302 /////////////////////
void LoadSav() {
  if (ramBuffer.cell[0] == 99) {
    Modedemarche = ramBuffer.cell[1]; V_HeureOuv = ramBuffer.cell[2];
    V_MinOuv = ramBuffer.cell[3]; V_HeureFerm = ramBuffer.cell[4];
    V_MinFerm = ramBuffer.cell[5];
    byte V_1LDRouv = ramBuffer.cell[6]; byte V_2LDRouv = ramBuffer.cell[7];
    byte V_1LDRferm = ramBuffer.cell[8]; byte V_2LDRferm = ramBuffer.cell[9];
    byte V_1Hysteresis = ramBuffer.cell[10]; byte V_2Hysteresis = ramBuffer.cell[11];
    Etattrappe = ramBuffer.cell[12]; Etatveille = ramBuffer.cell[13];
    byte V_1V_TpsAvveille = ramBuffer.cell[14]; byte V_2V_TpsAvveille = ramBuffer.cell[15];
    V_LDRouv = word(V_2LDRouv, V_1LDRouv); V_LDRferm = word(V_2LDRferm, V_1LDRferm);
    V_Hysteresis = word(V_2Hysteresis, V_1Hysteresis);
    V_TpsAvveille = word(V_2V_TpsAvveille, V_1V_TpsAvveille);
  }
}

//Gestion Navigation Bouton Bas ///////////////////
void NavBtbas() {
  if (Menu > 0) {
    if (Menu > 10) {
      Menu = 1;
    } else {
      Menu++;
    }
  }
  if (MenuMdm > 0) {
    if (MenuMdm > 10) {
      MenuMdm = 1;
    } else {
      MenuMdm++;
    }
  }
  if (MenuPara > 0) {
    if (MenuPara > 4) {
      MenuPara = 3;
    } else {
      MenuPara++;
    }
  }
  if (MenuParaProg > 0) {
    if (MenuParaProg > 4) {
      MenuParaProg = 3;
    } else {
      MenuParaProg++;
    }
  }
  if (MenuParaLDR > 0) {
    if (MenuParaLDR > 10) {
      MenuParaLDR = 1;
    } else {
      MenuParaLDR++;
    }
  }
  if (MenuSyst > 0) {
    if (MenuSyst > 4) {
      MenuSyst = 2;
    } else {
      MenuSyst++;
    }
  }
  if (MenuSystVeille > 0) {
    if (MenuSystVeille > 4) {
      MenuSystVeille = 2;
    } else {
      MenuSystVeille++;
    }
  }
  if (SystVeilleetat == 3) {
    Etatveille = !Etatveille;
  }
  if (SystVeilleTpsactiv == 3) {
    if (V_TpsAvveille < 4) {
      V_TpsAvveille = 180;
    } else {
      V_TpsAvveille--;
    }
  }
  if (ParaProgHouv == 3) {
    if (V_HeureOuv < 1) {
      V_HeureOuv = 23;
    } else {
      V_HeureOuv--;
    }
  }
  if (ParaProgHouv == 5) {
    if (V_MinOuv < 1) {
      V_MinOuv = 59;
    } else {
      V_MinOuv--;
    }
  }
  if (ParaProgHferm == 3) {
    if (V_HeureFerm < 1) {
      V_HeureFerm = 23;
    } else {
      V_HeureFerm--;
    }
  }
  if (ParaProgHferm == 5) {
    if (V_MinFerm < 1) {
      V_MinFerm = 59;
    } else {
      V_MinFerm--;
    }
  }
  if (ParaLDRouv == 3) {
    if (V_LDRouv < 1) {
      V_LDRouv = 999;
    } else {
      V_LDRouv--;
    }
  }
  if (ParaLDRferm == 3) {
    if (V_LDRferm < 1) {
      V_LDRferm = 999;
    } else {
      V_LDRferm--;
    }
  }
  if (ParaLDRhysteresis == 3) {
    if (V_Hysteresis < 1) {
      V_Hysteresis = 999;
    } else {
      V_Hysteresis--;
    }
  }
  if (SystReglheure == 3) {
    if (V_Tsystheure < 1) {
      V_Tsystheure = 23;
    } else {
      V_Tsystheure--;
    }
  }
  if (SystReglheure == 5) {
    if (V_Tsystminute < 1) {
      V_Tsystminute = 59;
    } else {
      V_Tsystminute--;
    }
  }
  if (SystReglheure == 7) {
    if (V_Tsystseconde < 1) {
      V_Tsystseconde = 59;
    } else {
      V_Tsystseconde--;
    }
  }
}

//Gestion Navigation Bouton HAUT ///////////////////
void NavBthaut() {
  if (Menu > 0) {
    if (Menu == 3) {
      Menu = 8;
    } else {
      Menu--;
    }
  }
  if (MenuMdm > 0) {
    if (MenuMdm == 3) {
      MenuMdm = 8;
    } else {
      MenuMdm--;
    }
  }
  if (MenuPara > 0) {
    if (MenuPara == 3) {
      MenuPara = 5;
    } else {
      MenuPara--;
    }
  }
  if (MenuParaProg > 0) {
    if (MenuParaProg == 3) {
      MenuParaProg = 5;
    } else {
      MenuParaProg--;
    }
  }
  if (MenuParaLDR > 0) {
    if (MenuParaLDR == 3) {
      MenuParaLDR = 8;
    } else {
      MenuParaLDR--;
    }
  }
  if (MenuSyst > 0) {
    if (MenuSyst == 3) {
      MenuSyst = 5;
    } else {
      MenuSyst--;
    }
  }
  if (MenuSystVeille > 0) {
    if (MenuSystVeille == 3) {
      MenuSystVeille = 5;
    } else {
      MenuSystVeille--;
    }
  }
  if (SystVeilleetat == 3) {
    Etatveille = !Etatveille;
  }
  if (SystVeilleTpsactiv == 3) {
    if (V_TpsAvveille > 179) {
      V_TpsAvveille = 3;
    } else {
      V_TpsAvveille++;
    }
  }
  if (ParaProgHouv == 3) {
    if (V_HeureOuv > 22) {
      V_HeureOuv = 0;
    } else {
      V_HeureOuv++;
    }
  }
  if (ParaProgHouv == 5) {
    if (V_MinOuv > 58) {
      V_MinOuv = 0;
    } else {
      V_MinOuv++;
    }
  }
  if (ParaProgHferm == 3) {
    if (V_HeureFerm > 22) {
      V_HeureFerm = 0;
    } else {
      V_HeureFerm++;
    }
  }
  if (ParaProgHferm == 5) {
    if (V_MinFerm > 58) {
      V_MinFerm = 0;
    } else {
      V_MinFerm++;
    }
  }
  if (ParaLDRouv == 3) {
    if (V_LDRouv > 998) {
      V_LDRouv = 0;
    } else {
      V_LDRouv++;
    }
  }
  if (ParaLDRferm == 3) {
    if (V_LDRferm > 998) {
      V_LDRferm = 0;
    } else {
      V_LDRferm++;
    }
  }
  if (ParaLDRhysteresis == 3) {
    if (V_Hysteresis > 998) {
      V_Hysteresis = 0;
    } else {
      V_Hysteresis++;
    }
  }
  if (SystReglheure == 3) {
    if (V_Tsystheure > 22) {
      V_Tsystheure = 0;
    } else {
      V_Tsystheure++;
    }
  }
  if (SystReglheure == 5) {
    if (V_Tsystminute > 58) {
      V_Tsystminute = 0;
    } else {
      V_Tsystminute++;
    }
  }
  if (SystReglheure == 7) {
    if (V_Tsystseconde > 58) {
      V_Tsystseconde = 0;
    } else {
      V_Tsystseconde++;
    }
  }
}

//Gestion Navigation Bouton Select ////////////////
void navmenuboutonselect() {
  if (Accueil > 0 && Veille == 0) {
    Accueil = 0; Menu = 1;
  }
  if (Menu == 3) {
    Menu = 0; MenuMdm = 1;
  }
  if (Menu == 4) {
    Menu = 0; MenuPara = 1;
  }
  if (Menu == 5) {
    MenuSyst = 1; Menu = 0;
  }
  if (Menu == 11) {
    Accueil = 1; Menu = 0;
  }
  if (MenuMdm == 3) {
    Modedemarche = MenuMdm - 2; MenuMdm = 0; Menu = 1; Sav();
  }
  if (MenuMdm == 4) {
    Modedemarche = MenuMdm - 2; MenuMdm = 0; Menu = 1; Sav();
  }
  if (MenuMdm == 5) {
    Modedemarche = MenuMdm - 2;
    MenuMdm = 0; Menu = 1; Sav();
  }
  if (MenuMdm == 11) {
    MenuMdm = 0; Menu = 1;
  }
  if (MenuPara == 5) {
    MenuPara = 0; Menu = 1;
  }
  if (MenuPara == 3) {
    MenuPara = 0; MenuParaProg = 1;
  }
  if (MenuPara == 4) {
    MenuPara = 0; MenuParaLDR = 1;
  }
  if (MenuParaLDR == 11) {
    MenuParaLDR = 0; MenuPara = 1;
  }
  if (MenuSyst == 3) {
    MenuSyst = 0; SystReglheure = 1;
  }
  if (MenuSyst == 4) {
    MenuSyst = 0; MenuSystVeille = 1;
  }
  if (MenuSyst == 5) {
    MenuSyst = 0; Menu = 1;
  }
  if (MenuSystVeille == 3) {
    MenuSystVeille = 0; SystVeilleetat = 1;
  }
  if (MenuSystVeille == 4) {
    MenuSystVeille = 0; SystVeilleTpsactiv = 1;
  }
  if (MenuSystVeille == 5) {
    MenuSystVeille = 0; MenuSyst = 1;
  }
  if (SystVeilleetat == 3) {
    SystVeilleetat = 0; MenuSystVeille = 1; Sav();
  }
  if (SystVeilleTpsactiv == 3) {
    SystVeilleTpsactiv = 0; MenuSystVeille = 1; Sav();
  }
  if (MenuParaProg == 3) {
    MenuParaProg = 0; ParaProgHouv = 1;
  }
  if (MenuParaProg == 4) {
    MenuParaProg = 0; ParaProgHferm = 1;
  }
  if (MenuParaProg == 5) {
    MenuParaProg = 0; MenuPara = 1;
  }
  if (ParaProgHouv == 3) {
    ParaProgHouv = 4;
  }
  if (ParaProgHouv == 5) {
    MenuParaProg = 1; ParaProgHouv = 0; Sav();
  }
  if (ParaProgHferm == 3) {
    ParaProgHferm = 4;
  }
  if (ParaProgHferm == 5) {
    MenuParaProg = 1; ParaProgHferm = 0; Sav();
  }
  if (MenuParaLDR == 3) {
    MenuParaLDR = 0; ParaLDRouv = 1;
  }
  if (MenuParaLDR == 4) {
    MenuParaLDR = 0; ParaLDRferm  = 1;
  }
  if (MenuParaLDR == 5) {
    MenuParaLDR = 0; ParaLDRhysteresis = 1;
  }
  if (ParaLDRouv == 3) {
    MenuParaLDR = 1; ParaLDRouv = 0; Sav();
  }
  if (ParaLDRferm == 3) {
    MenuParaLDR = 1; ParaLDRferm = 0; Sav();
  }
  if (ParaLDRhysteresis == 3) {
    MenuParaLDR = 1; ParaLDRhysteresis = 0; Sav();
  }
  if (SystReglheure == 3) {
    SystReglheure = 4;
  }
  if (SystReglheure == 5) {
    SystReglheure = 6;
  }
  if (SystReglheure == 7) {
    SavHeure(); SystReglheure = 0; MenuSyst = 1;
  }
}
//Gestion Navigation Bouton HAUT rapide ////////////
void NavBthautrapide() {
  if ((timerarduino - previousTimer6) > Timer6ON) {
    if (ParaLDRouv == 3) {
      if (V_LDRouv > 988) {
        V_LDRouv = 0;
      } else {
        V_LDRouv = V_LDRouv + 10;
      }
    }
    if (ParaLDRferm == 3) {
      if (V_LDRferm > 988) {
        V_LDRferm = 0;
      } else {
        V_LDRferm = V_LDRferm + 10;
      }
    }
    if (ParaLDRhysteresis == 3) {
      if (V_Hysteresis > 988) {
        V_Hysteresis = 0;
      } else {
        V_Hysteresis = V_Hysteresis + 10;
      }
    }
    if (SystVeilleTpsactiv == 3) {
      if (V_TpsAvveille > 169) {
        V_TpsAvveille = 3;
      } else {
        V_TpsAvveille = V_TpsAvveille + 10;
      }
    }
    previousTimer6 = timerarduino;
  }
}
//Gestion Navigation Bouton BAS rapide  ////////////
void NavBtbasrapide() {
  if ((timerarduino - previousTimer6) > Timer6ON) {
    if (ParaLDRouv == 3) {
      if (V_LDRouv < 11) {
        V_LDRouv = 999;
      } else {
        V_LDRouv = V_LDRouv - 10;
      }
    }
    if (ParaLDRferm == 3) {
      if (V_LDRferm < 11) {
        V_LDRferm = 999;
      } else {
        V_LDRferm = V_LDRferm - 10;
      }
    }
    if (ParaLDRhysteresis == 3) {
      if (V_Hysteresis < 11) {
        V_Hysteresis = 999;
      } else {
        V_Hysteresis = V_Hysteresis - 10;
      }
    }
    if (SystVeilleTpsactiv == 3) {
      if (V_TpsAvveille < 14) {
        V_TpsAvveille = 180;
      } else {
        V_TpsAvveille = V_TpsAvveille - 10;
      }
    }
    previousTimer6 = timerarduino;
  }
}


void Intro() {
  lcd.home();
  lcd.setCursor(1, 0); lcd.write(1);
  lcd.setCursor(2, 0); lcd.write(2);
  lcd.setCursor(1, 1); lcd.write(3);
  lcd.setCursor(2, 1); lcd.write(4);
  lcd.setCursor(6, 0); lcd.print("DomoPoule");
  lcd.setCursor(5, 1); lcd.print("Version.5-B");
  lcd.setCursor(0, 3); lcd.print("  www.robdomo.com   ");
  delay(2000);
}

//Gestion Mise en veille Ecran/////////////////////
void EcrVeille() {
  Timer4ON = V_TpsAvveille * 1000;
  if (((timerarduino - previousTimer4) > Timer4ON) && Accueil == 7 && Etatveille == 1) {
    lcd.noBacklight(); Veille = 1;
  }
  if (EtatBtselect == 1 || EtatBthaut == 1 || EtatBtbas == 1 || Accueil != 7) {
    lcd.backlight(); previousTimer4 = timerarduino;
    Veille = 0;
  }
}
