#include <AccelStepper.h>

// Définition des broches pour le DRV8825 + Expansion Board
#define STEP_PIN 9    // Pin STEP de l'expansion board
#define DIR_PIN 10    // Pin DIR de l'expansion board
#define ENABLE_PIN 8  // Pin EN de l'expansion board
#define PIN_BOUTON 3  // Votre bouton poussoir

// On change le mode en "DRIVER" (2 fils : Step et Direction)
AccelStepper stepper(AccelStepper::DRIVER, STEP_PIN, DIR_PIN);

enum Etat { REPOS, ALLER, PAUSE, RETOUR };
Etat etatActuel = REPOS;

unsigned long chronoPause = 0;
const long distanceCible = 24000; // 6000 pas

void setup() {
  pinMode(PIN_BOUTON, INPUT_PULLUP);
  pinMode(ENABLE_PIN, OUTPUT);
  
  // Par défaut, on désactive le moteur au démarrage (HIGH = Désactivé sur DRV8825)
  digitalWrite(ENABLE_PIN, HIGH); 

  stepper.setMaxSpeed(2500.0);
  stepper.setAcceleration(1200.0); 
}

void loop() {
  // Indispensable pour que AccelStepper génère les impulsions
  stepper.run();

  switch (etatActuel) {
    
    case REPOS:
      if (digitalRead(PIN_BOUTON) == LOW) {
        digitalWrite(ENABLE_PIN, LOW); // RÉVEIL : On active le driver
        delay(1); // Petit délai de sécurité pour l'électronique
        stepper.moveTo(distanceCible);
        etatActuel = ALLER;
      }
      break;

    case ALLER:
      if (stepper.distanceToGo() == 0) {
        chronoPause = millis();
        etatActuel = PAUSE;
      }
      break;

    case PAUSE:
      if (millis() - chronoPause >= 1500) {
        stepper.moveTo(0);
        etatActuel = RETOUR;
      }
      break;

    case RETOUR:
      if (stepper.distanceToGo() == 0) {
        // Optionnel : on désactive le courant pour que le moteur ne chauffe pas au repos
        // Attention : le moteur peut être tourné à la main s'il n'y a plus de courant.
        digitalWrite(ENABLE_PIN, HIGH); 
        etatActuel = REPOS;
      }
      break;
  }
}