#include <Wire.h>
#include <Adafruit_SHT4x.h>

Adafruit_SHT4x sht4 = Adafruit_SHT4x();

void setup() {
  // Sur un Pro Mini 8MHz, assurez-vous que le moniteur série est bien sur 9600
  Serial.begin(9600); 
  while (!Serial) delay(10);

  Serial.println("Initialisation du SHT41...");

  if (!sht4.begin()) {
    Serial.println("Erreur : SHT41 introuvable !");
    while (1) delay(1);
  }

  // --- PHASE DE NETTOYAGE ---
  //Serial.println("Activation du chauffage pour stabilisation (1s)...");
  // On chauffe à haute puissance pendant 1 seconde pour évaporer l'humidité
  //sht4.setHeater(SHT4X_HIGH_HEATER_1S); 
  
  // On attend un peu que le capteur refroidisse après le chauffage 
  // pour ne pas fausser la première mesure de température
  delay(2000); 

  // Réglage de la précision
  sht4.setPrecision(SHT4X_HIGH_PRECISION);
  Serial.println("SHT41 pret !");
}

void loop() {
  sensors_event_t humidity, temp;
  
  // Lecture du capteur
  sht4.getEvent(&humidity, &temp);

  // Affichage des valeurs
  Serial.print("Temperature : "); 
  Serial.print(temp.temperature); 
  Serial.print(" C  |  ");
  
  Serial.print("Humidite : "); 
  Serial.print(humidity.relative_humidity); 
  Serial.println(" %");

  // On attend 5 secondes entre les lectures pour éviter l'auto-échauffement
  delay(5000); 
}