// --- Définition des broches et variables ---
#define bouton1 2       // Bouton pour incrémenter (augmenter) l'angle
#define bouton2 3       // Bouton pour décrémenter (diminuer) l'angle
int Posservo;           // Variable stockant la position actuelle du servo

int PosServomini = 10;  // Limite basse de sécurité pour l'angle du servo
int PosServomax = 75;   // Limite haute de sécurité pour l'angle du servo

// --- Bibliothèques ---
#include <Servo.h>      // Bibliothèque pour le contrôle des servomoteurs
Servo myservo;          // Création de l'objet servo

#include <Adafruit_GFX.h>     // Bibliothèque graphique de base
#include <Adafruit_ST7789.h>  // Bibliothèque spécifique au contrôleur de l'écran (GMT020-02)

// Définition des broches de communication pour l'écran TFT
#define TFT_CS 8    // Chip Select
#define TFT_DC 10   // Data/Command
#define TFT_RST 9   // Reset

// Initialisation de l'écran avec les broches définies
Adafruit_ST7789 tft = Adafruit_ST7789(TFT_CS, TFT_DC, TFT_RST);

void setup() {
  // Configuration des boutons en entrée avec résistance de pull-up interne
  pinMode(bouton1, INPUT_PULLUP);
  pinMode(bouton2, INPUT_PULLUP);
  
  myservo.attach(4); // Attache le servomoteur à la broche numérique 4
  
  // Initialisation de l'écran OLED/TFT (240x320 pixels)
  tft.init(240, 320, SPI_MODE2); 
  tft.setRotation(2);            // Orientation de l'affichage
  tft.fillScreen(ST77XX_BLACK);  // Efface l'écran en noir
  tft.setTextWrap(false);        // Désactive le retour à la ligne automatique
  
  // Configuration du texte d'en-tête
  tft.setTextColor(ST77XX_GREEN, ST77XX_BLACK); // Texte vert sur fond noir
  tft.setTextSize(2);
  tft.setCursor(15, 5);
  tft.print("projetsduino.com");
  
  // Affichage des étiquettes statiques
  tft.setCursor(25, 101);
  tft.print("Position servo :");
  
  tft.setTextSize(2); 
  tft.setCursor(5, 241);
  tft.print("Position mini :");
  tft.setCursor(200, 241);
  tft.print(PosServomini);
  
  tft.setCursor(5, 271);
  tft.print("Position max :"); // Correction : Changé "mini" en "max" pour la clarté
  tft.setCursor(200, 271);
  tft.print(PosServomax);
  
  delay(1000); // Pause initiale d'une seconde
}

void loop() {
  
  // Lecture de l'état des boutons (LOW = bouton pressé car INPUT_PULLUP)
  if (digitalRead(bouton1) == LOW) {
    Posservo = Posservo + 3; // Augmente l'angle de 3 degrés
  }
  if (digitalRead(bouton2) == LOW) {
    Posservo = Posservo - 3; // Diminue l'angle de 3 degrés
  }
  
  // Sécurité : Empêche la valeur de sortir des bornes mini et maxi définies
  Posservo = constrain(Posservo, PosServomini, PosServomax); 
  
  // Mise à jour de l'affichage de la position actuelle
  tft.setTextSize(8);            // Grande taille pour la valeur principale
  tft.setCursor(70, 151);
  tft.print(Posservo);           // Affiche la valeur numérique
  tft.print("  ");               // Espace pour effacer les anciens chiffres si la valeur diminue
  
  // Commande physique du servomoteur
  myservo.write(Posservo);  
  
  delay(15); // Petite pause pour stabiliser le mouvement et la lecture des boutons
}