//Un tableau qui stocke les numéros des broches (pins) numériques de l'Arduino auxquelles les 9 LED sont connectées.
int LEDsortie[] = { 2, 3, 4, 5, 6, 7, 8, 9, 10 };
// Variable pour suivre quelle LED est actuellement allumée dans la séquence
int LEDon;
//État global des LED (HIGH pour allumé/actif, LOW pour éteint/inactif)
int LEDsState = LOW;
//Variable pour déterminer le sens de la séquence d'allumage des LED
int LEDsSens;

//Inclut la bibliothèque pour la réception IR.
#include <IRremote.h>
//Définit la broche numérique 11 comme entrée pour le récepteur IR
#define IR_RECEIVE_PIN 11
//Stocke la commande IR reçue sous forme décimale
int codeIRdecimal;

//Variable pour stocker le dernier moment où la LED a été mise à jour,
// utilisé pour la temporisation non bloquante (millis()).
unsigned long previousMillis = 0;
//L'intervalle de temps (en millisecondes) entre le changement de LED dans la séquence
//Commence à 500 ms.
int interval = 500;


void setup() {
  Serial.begin(9600);
  //Configure les 9 broches du tableau LEDsortie comme des sorties (pour contrôler les LED).
  for (int i = 0; i < 9; i++) {
    pinMode(LEDsortie[i], OUTPUT);
  }
  //Initialise le récepteur IR sur la broche 11.
  IrReceiver.begin(IR_RECEIVE_PIN);
}

void loop() {
  if (IrReceiver.decode()) {
    //Stocke la commande IR reçue sous forme décimale
    codeIRdecimal = IrReceiver.decodedIRData.command;
    //Affiche la valeur décimale reçue sur le moniteur série
    Serial.print("Valeur IR décimal :");
    Serial.println(codeIRdecimal);
    //Prépare le récepteur IR à recevoir la prochaine commande.
    IrReceiver.resume();
  }

  //Commande ON/OFF (Bouton Power).
  if (codeIRdecimal == 69) {
    if (LEDsState == LOW) {
      LEDsState = HIGH;
    } else {
      LEDsState = LOW;
      //Éteint toutes les LED.
      for (int i = 0; i < 9; i++) {
        digitalWrite(LEDsortie[i], LOW);
      }
    }
  }

  if (codeIRdecimal == 67) {
    //Définit le sens de la séquence à 0
    LEDsSens = 0;
  }

  if (codeIRdecimal == 68) {
    //Définit le sens de la séquence à 1
    LEDsSens = 1;
  }

  if (codeIRdecimal == 9) {
    //Diminue l'intervalle de 100 ms, ce qui accélère le défilement de la séquence.
    interval = interval - 100;
  }
  if (codeIRdecimal == 7) {
    //Augmente l'intervalle de 100 ms, ce qui ralentit le défilement.
    interval = interval + 100;
  }
  //Limite l'intervalle entre 100 ms (plus rapide) et 3000 ms (plus lent) pour éviter des valeurs extrêmes.
  interval = constrain(interval, 100, 3000);
  //Réinitialise la commande IR
  codeIRdecimal = 0;

  ////////////////////////
  //Cette section utilise la méthode millis() pour gérer le temps sans bloquer le programme
  ////////////////////////

  //Stocke le temps actuel.
  unsigned long currentMillis = millis();
  //Vérifie si l'intervalle s'est écoulé ET si les LED sont dans l'état HIGH (allumé).
  if ((currentMillis - previousMillis >= interval) && LEDsState == HIGH) {
    //Met à jour le temps de la dernière mise à jour.
    previousMillis = currentMillis;
    //Éteint toutes les LED.
    for (int i = 0; i < 9; i++) {
      digitalWrite(LEDsortie[i], LOW);
    }

    //Allume la LED actuelle pointée par l'index LEDson
    digitalWrite(LEDsortie[LEDon], HIGH);

    //Sens croissant. Incrémente LEDson. Si LEDson atteint 9 (au-delà de l'index du tableau),
    // il est réinitialisé à 0 pour recommencer la séquence.
    if (LEDsSens == 0) {
      if (LEDon < 9) {
        LEDon++;
      }
      if (LEDon == 9) {
        LEDon = 0;
      }
    }
    //Sens décroissant. Décrémente LEDson. Si LEDson atteint -1,
    // il est réinitialisé à 8 (le dernier index du tableau) pour recommencer en sens inverse.
    else {
      if (LEDon >= 0) {
        LEDon--;
      }
      if (LEDon == -1) {
        LEDon = 8;
      }
    }
  }
}