#include <PS2X_lib.h>  //for v1.6
#define PS2_DAT 43     
#define PS2_CMD 42     
#define PS2_SEL 41     
#define PS2_CLK 40     
#define pressures false
#define rumble false
PS2X ps2x;  // create PS2 Controller Class

int error = 0;
byte type = 0;
byte vibrate = 0;

const int L1in1Pin = 33;  //Broche de commande L298N
const int L1in2Pin = 32;  //Broche de commande L298N
const int L1in3Pin = 31;  //Broche de commande L298N
const int L1in4Pin = 30;  //Broche de commande L298N
const int L2in1Pin = 29;  //Broche de commande L298N
const int L2in2Pin = 28;  //Broche de commande L298N
const int L2in3Pin = 27;  //Broche de commande L298N
const int L2in4Pin = 26;  //Broche de commande L298N

void setup() {
  Serial.begin(9600);

  pinMode(L1in1Pin, OUTPUT);
  pinMode(L1in2Pin, OUTPUT);
  pinMode(L1in3Pin, OUTPUT);
  pinMode(L1in4Pin, OUTPUT);
  pinMode(L2in1Pin, OUTPUT);
  pinMode(L2in2Pin, OUTPUT);
  pinMode(L2in3Pin, OUTPUT);
  pinMode(L2in4Pin, OUTPUT);

  Serial.begin(57600);

  delay(300);  
  
  error = ps2x.config_gamepad(PS2_CLK, PS2_CMD, PS2_SEL, PS2_DAT, pressures, rumble);

  if (error == 0) {
    Serial.print("Contrôleur trouvé, configuration réussie");
  } else if (error == 1)
    Serial.println("Contrôleur introuvable. Vérifiez le câblage.");

  else if (error == 2)
    Serial.println("Contrôleur détecté mais ne répondant pas aux commandes.");

  else if (error == 3)
    Serial.println("Le contrôleur refuse de passer en mode Pressions, il se peut qu'il ne le prenne pas en charge.");
  type = ps2x.readType();
}

void loop() {
  delay(50);  
  ps2x.read_gamepad(false, vibrate);

  if (ps2x.Button(PSB_PAD_UP)) {  
    Avant();
  } else if (ps2x.Button(PSB_PAD_RIGHT)) {
    Droite();
  } else if (ps2x.Button(PSB_PAD_LEFT)) {
    Gauche();
  } else if (ps2x.Button(PSB_PAD_DOWN)) {
    Arriere();
  } else {
    Arret();
  }
}

void Avant() {
  digitalWrite(L1in1Pin, LOW);   //ARD
  digitalWrite(L1in2Pin, HIGH);  //ARD
  digitalWrite(L1in3Pin, HIGH);  //ARG
  digitalWrite(L1in4Pin, LOW);   //ARG
  digitalWrite(L2in1Pin, HIGH);  //AVG
  digitalWrite(L2in2Pin, LOW);   //AVG
  digitalWrite(L2in3Pin, LOW);   //AVD
  digitalWrite(L2in4Pin, HIGH);  //AVD
}

void Arriere() {
  digitalWrite(L1in1Pin, HIGH);  //ARD
  digitalWrite(L1in2Pin, LOW);   //ARD
  digitalWrite(L1in3Pin, LOW);   //ARG
  digitalWrite(L1in4Pin, HIGH);  //ARG
  digitalWrite(L2in1Pin, LOW);   //AVG
  digitalWrite(L2in2Pin, HIGH);  //AVG
  digitalWrite(L2in3Pin, HIGH);  //AVD
  digitalWrite(L2in4Pin, LOW);   //AVD
}

void Droite() {
  digitalWrite(L1in1Pin, HIGH);  //ARD
  digitalWrite(L1in2Pin, LOW);   //ARD
  digitalWrite(L1in3Pin, HIGH);   //ARG
  digitalWrite(L1in4Pin, LOW);  //ARG
  digitalWrite(L2in1Pin, HIGH);   //AVG
  digitalWrite(L2in2Pin, LOW);  //AVG
  digitalWrite(L2in3Pin, HIGH);  //AVD
  digitalWrite(L2in4Pin, LOW);   //AVD
}

void Gauche() {
  digitalWrite(L1in1Pin, LOW);  //ARD
  digitalWrite(L1in2Pin, HIGH);   //ARD
  digitalWrite(L1in3Pin, LOW);   //ARG
  digitalWrite(L1in4Pin, HIGH);  //ARG
  digitalWrite(L2in1Pin, LOW);   //AVG
  digitalWrite(L2in2Pin, HIGH);  //AVG
  digitalWrite(L2in3Pin, LOW);  //AVD
  digitalWrite(L2in4Pin, HIGH);   //AVD
}

void Arret() {
  digitalWrite(L1in1Pin, 0);  //ARD
  digitalWrite(L1in2Pin, 0);  //ARD
  digitalWrite(L1in3Pin, 0);  //ARG
  digitalWrite(L1in4Pin, 0);  //ARG
  digitalWrite(L2in1Pin, 0);  //AVG
  digitalWrite(L2in2Pin, 0);  //AVG
  digitalWrite(L2in3Pin, 0);  //AVD
  digitalWrite(L2in4Pin, 0);  //AVD
}