#include <SoftwareSerial.h>
#include <Adafruit_NeoPixel.h>
#define PIN 9         //
#define NUMPIXELS 12  // Popular NeoPixel ring size
Adafruit_NeoPixel pixels(NUMPIXELS, PIN, NEO_GRB + NEO_KHZ800);
#define Activdetect 250

#define RX_PIN 10        // Broche RX du radar
#define MOTOR_PIN 5      // Numéro de broche du contrôleur moteur sur Arduino Uno
int VitesseMOTOR = 173;  // Réglage de la vitesse moteur 0-255
#define NB_DATA 4        // Mesure 1, Mesure 2, Mesure 3, Mesure 4
#define DATA_SIZE 5      // angle, speed, distance, invalid, strengh
int Framedata[NB_DATA][DATA_SIZE];
int DataAngle[24];
#define PACKET_SIZE 22
uint8_t Trame[PACKET_SIZE];  // Buffer trame (22 octets)

unsigned int packetIndex = 0;  // Packet index
bool waitPacket = true;

bool debug = 0;              //Active donnée pour la console si debug = 1
int ActivErreurlecture = 0;  //Filtre les données erronées si ActivErreurlecture = 0
int Erreurlecture;
int ErreurlectureDist1;
int ErreurlectureDist2;
int ErreurlectureDist3;
int ErreurlectureDist4;

SoftwareSerial lidarSerial = SoftwareSerial(RX_PIN, 3);

unsigned long previousMillis = 0;
const int interval = 350;

int sensorPin = A0;
int sensorValue = 0;

void setup() {

  lidarSerial.begin(115200);
  Serial.begin(115200);
  pinMode(RX_PIN, INPUT);
  analogWrite(MOTOR_PIN, 255);
  pixels.setBrightness(100);
  pixels.begin();  // INITIALIZE NeoPixel strip object (REQUIRED)

  // Initialiser le tampon de paquets
  for (int i = 0; i < PACKET_SIZE; i++) Trame[i] = 0;
}


void loop() {

  unsigned long currentMillis = millis();
  if (currentMillis - previousMillis >= interval) {
    previousMillis = currentMillis;
    Led();
    sensorValue = analogRead(sensorPin);
    VitesseMOTOR = map(sensorValue, 0, 1024, 0, 255);
    for (int i = 0; i < NUMPIXELS; i++) {
      DataAngle[i] = 0;
    }
  }
  analogWrite(MOTOR_PIN, VitesseMOTOR);  // Envoyer un signal PWM au contrôleur de moteur

  if (lidarSerial.available() > 0) {
    uint8_t BufferByte = lidarSerial.read();
    if (waitPacket) {
      if (BufferByte == 0xFA) {
        Erreurlecture = 0;
        ErreurlectureDist1 = 0;
        ErreurlectureDist2 = 0;
        ErreurlectureDist3 = 0;
        ErreurlectureDist4 = 0;
        packetIndex = 0;
        waitPacket = false;
        Trame[packetIndex++] = BufferByte;
      }
    } else {
      if (Trame[0] == 0xFA) {
        Trame[packetIndex++] = BufferByte;
        if (packetIndex >= PACKET_SIZE) {
          uint16_t calc = Checksum(Trame);
          uint16_t recv = Trame[20] | (Trame[21] << 8);
          if (calc != recv) {
            //Serial.println("checksum invalide");
            Erreurlecture = 1;
          } else {
            //Serial.print("valide");
          }
          waitPacket = true;
          decodePacket(Trame, PACKET_SIZE);
          if (debug == 0 && Erreurlecture == 0) {
            if (ErreurlectureDist1 == 0) {
              sendData1();
              for (int i = 1; i < NUMPIXELS; i++) {
                if (Framedata[0][0] > i * 30 && Framedata[0][0] <= (i + 1) * 30 && Framedata[0][2] < Activdetect && DataAngle[i] == 0) {
                  DataAngle[i] = 1;
                }
              }
            }
            if (ErreurlectureDist2 == 0) {
              sendData2();
              for (int i = 0; i < NUMPIXELS; i++) {
                if (Framedata[1][0] > i * 30 && Framedata[1][0] <= (i + 1) * 30 && Framedata[1][2] < Activdetect && DataAngle[i] == 0) {
                  DataAngle[i] = 1;
                }
              }
            }
            if (ErreurlectureDist3 == 0) {
              sendData3();
              for (int i = 0; i < NUMPIXELS; i++) {
                if (Framedata[2][0] > i * 30 && Framedata[2][0] <= (i + 1) * 30 && Framedata[2][2] < Activdetect && DataAngle[i] == 0) {
                  DataAngle[i] = 1;
                }
              }
            }
            if (ErreurlectureDist4 == 0) {
              sendData4();
              for (int i = 0; i < NUMPIXELS; i++) {
                if (Framedata[3][0] > i * 30 && Framedata[3][0] <= (i + 1) * 30 && Framedata[3][2] < Activdetect && DataAngle[i] == 0) {
                  DataAngle[i] = 1;
                }
              }
            }
          }
          if (debug == 1) DebugData(Trame, PACKET_SIZE);
        }
      }
    }
  }
}


void decodePacket(uint8_t packet[], int packetSize) {
  //Remise à zero des Frame datas
  for (int i = 0; i < NB_DATA; i++) {
    for (int b = 0; b < DATA_SIZE; b++) {
      Framedata[i][b] = 0;
    }
  }

  for (int i = 0; i < packetSize; i++) {
    int test = i;
    switch (test) {
      case 1:
        //Angle
        Framedata[0][0] = (Trame[1] - 0xA0) * 4;        // Convertion de la valeur 0 ~ 360°
        Framedata[1][0] = ((Trame[1] - 0xA0) * 4) + 1;  // Convertion de la valeur 0 ~ 360°
        Framedata[2][0] = ((Trame[1] - 0xA0) * 4) + 2;  // Convertion de la valeur 0 ~ 360°
        Framedata[3][0] = ((Trame[1] - 0xA0) * 4) + 3;  // Convertion de la valeur 0 ~ 360°
        //Filtre Angle non valide
        if (ActivErreurlecture == 0 && (Framedata[0][0] > 360 || Framedata[0][0] < 0)) {
          Erreurlecture = 1;
        }
        break;
      case 2:
        //Vitesse
        Framedata[0][1] = ((Trame[3] << 8) | Trame[2]) / 64.f;
        Framedata[1][1] = ((Trame[3] << 8) | Trame[2]) / 64.f;
        Framedata[2][1] = ((Trame[3] << 8) | Trame[2]) / 64.f;
        Framedata[3][1] = ((Trame[3] << 8) | Trame[2]) / 64.f;
        //Filtre Vitesse non valide
        if (ActivErreurlecture == 0 && (Framedata[0][1] < 50)) {
          Erreurlecture = 1;
        }
        break;

      case 4:
        //Distance 1
        Framedata[0][2] |= ((Trame[4 + 1] & 0x3F) << 8) | Trame[4];
        //Filtre Distance non valide
        if (ActivErreurlecture == 0 && (Framedata[0][2] < 100 || Framedata[0][2] > 3000)) {
          ErreurlectureDist1 = 1;
        }
        break;
      case 5:
        //Ce champ indique si la mesure est invalide(invalid)
        //Si ce bit est 1 → mesure invalide (le capteur n’a pas pu renvoyer de distance correcte).
        //Si 0 → mesure valide (distance correcte en mm).
        Framedata[0][3] = (Trame[4 + 1] & 0x80) != 0;
        //Filtre mesure invalide
        if (ActivErreurlecture == 0 && (Framedata[0][3] == 1)) {
          ErreurlectureDist1 = 1;
        }
        break;
      case 6:
        //Force du signal réfléchi (strengh)
        //Faible valeur (≈0–100) → retour faible → réflexion mauvaise ou distance longue.
        //Grande valeur (>1000) → retour fort → bonne surface réfléchissante, distance fiable.
        Framedata[0][4] = (Trame[4 + 2]) | ((Trame[4 + 3]) << 8);
        //Filtre Force du signal
        if (ActivErreurlecture == 0 && (Framedata[0][4] < 100)) {
          ErreurlectureDist1 = 1;
        }
        break;

      case 8:
        //Distance 2
        Framedata[1][2] |= ((Trame[8 + 1] & 0x3F) << 8) | Trame[8];
        if (ActivErreurlecture == 0 && (Framedata[1][2] < 100 || Framedata[1][2] > 3000)) {
          ErreurlectureDist2 = 1;
        }
        break;
      case 9:
        //invalid
        Framedata[1][3] = (Trame[8 + 1] & 0x80) != 0;
        if (ActivErreurlecture == 0 && (Framedata[1][3] == 1)) {
          ErreurlectureDist2 = 1;
        }
        break;
      case 10:
        //strengh
        Framedata[1][4] = (Trame[8 + 2]) | ((Trame[8 + 3]) << 8);
        if (ActivErreurlecture == 0 && (Framedata[1][4] < 100)) {
          ErreurlectureDist2 = 1;
        }
        break;

      case 12:
        //Distance 3
        Framedata[2][2] |= ((Trame[12 + 1] & 0x3F) << 8) | Trame[12];
        if (ActivErreurlecture == 0 && (Framedata[2][2] < 100 || Framedata[2][2] > 3000)) {
          ErreurlectureDist3 = 1;
        }
        break;
      case 13:
        //invalid
        Framedata[2][3] = (Trame[12 + 1] & 0x80) != 0;
        if (ActivErreurlecture == 0 && (Framedata[2][3] == 1)) {
          ErreurlectureDist3 = 1;
        }
        break;
      case 14:
        //strengh
        Framedata[2][4] = (Trame[12 + 2]) | ((Trame[12 + 3]) << 8);
        if (ActivErreurlecture == 0 && (Framedata[2][4] < 100)) {
          ErreurlectureDist3 = 1;
        }
        break;

      case 16:
        //Distance 4
        Framedata[3][2] |= ((Trame[16 + 1] & 0x3F) << 8) | Trame[16];
        if (ActivErreurlecture == 0 && (Framedata[3][2] < 100 || Framedata[3][2] > 3000)) {
          ErreurlectureDist4 = 1;
        }
        break;
      case 17:
        //invalid
        Framedata[3][3] = (Trame[16 + 1] & 0x80) != 0;
        if (ActivErreurlecture == 0 && (Framedata[3][3] == 1)) {
          ErreurlectureDist4 = 1;
        }
        break;
      case 18:
        //strengh
        Framedata[3][4] = (Trame[16 + 2]) | ((Trame[16 + 3]) << 8);
        if (ActivErreurlecture == 0 && (Framedata[3][4] < 100)) {
          ErreurlectureDist4 = 1;
        }
        break;

      default:
        break;
    }
  }
}

int sendData1() {
  //[angle1, distance 1,vitesse 1, invalid1, strengh1]
  Serial.print(Framedata[0][0]);
  Serial.print(",");
  Serial.print(Framedata[0][2]);
  Serial.print(",");
  Serial.println(Framedata[0][1]);
}
int sendData2() {
  //[angle2, distance 2,vitesse 2, invalid2, strengh2]
  Serial.print(Framedata[1][0]);
  Serial.print(",");
  Serial.print(Framedata[1][2]);
  Serial.print(",");
  Serial.println(Framedata[1][1]);
}

int sendData3() {
  //[angle3, distance 3,vitesse 3, invalid3, strengh3]
  Serial.print(Framedata[2][0]);
  Serial.print(",");
  Serial.print(Framedata[2][2]);
  Serial.print(",");
  Serial.println(Framedata[2][1]);
}

int sendData4() {
  //[angle4, distance 4,vitesse 4, invalid4, strengh4]
  Serial.print(Framedata[3][0]);
  Serial.print(",");
  Serial.print(Framedata[3][2]);
  Serial.print(",");
  Serial.println(Framedata[3][1]);
}

int DebugData(uint8_t packet[], int packetSize) {
  for (int i = 0; i < packetSize; i++) {
    Serial.print("0x");
    Serial.print(packet[i]);
    Serial.print('\t');
  }
  Serial.println("");
  for (int i = 0; i < packetSize; i++) {
    Serial.print(packet[i], HEX);
    Serial.print('\t');
  }
  Serial.println("");
  for (int i = 0; i < NB_DATA; i++) {
    Serial.print("Angle ");
    Serial.print(i + 1);
    Serial.print(" : ");
    Serial.print(Framedata[i][0]);
    Serial.print('\t');
    Serial.print("Dist ");
    Serial.print(i + 1);
    Serial.print(" : ");
    Serial.print(Framedata[i][2]);
    Serial.print('\t');
    Serial.print("RPM ");
    Serial.print(i + 1);
    Serial.print(" : ");
    Serial.print(Framedata[i][1]);
    Serial.print('\t');
    Serial.print("Invalid ");
    Serial.print(i + 1);
    Serial.print(" : ");
    Serial.print(Framedata[i][3]);
    Serial.print('\t');
    Serial.print("Strength ");
    Serial.print(i + 1);
    Serial.print(" : ");
    Serial.print(Framedata[i][4]);
    Serial.println('\t');
  }
}


uint16_t Checksum(const uint8_t *data20) {
  uint16_t words[10];
  for (int i = 0; i < 10; i++) {
    words[i] = data20[2 * i] | (data20[2 * i + 1] << 8);
  }

  uint32_t chk32 = 0;
  for (int i = 0; i < 10; i++) {
    chk32 = (chk32 << 1) + words[i];
    chk32 &= 0xFFFFFFFF;
  }

  uint16_t checksum = ((chk32 & 0x7FFF) + (chk32 >> 15)) & 0x7FFF;
  return checksum;
}
int Led() {
  for (int i = 0; i < NUMPIXELS; i++) {
    if (DataAngle[i] == 1) {
      pixels.setPixelColor(i, pixels.Color(150, 0, 0));
    } else {
      pixels.setPixelColor(i, pixels.Color(0, 150, 0));
    }
    pixels.show();
  }
}
