#include <Servo.h>
Servo myservo1;  // créer un objet Servo pour contrôler un servo
Servo myservo2;  // créer un objet Servo pour contrôler un servo

#define LDR1_PIN A0 // sélectionnez la broche d'entrée pour le LDR1
#define LDR2_PIN A1 // sélectionnez la broche d'entrée pour le LDR2
#define LDR3_PIN A2 // sélectionnez la broche d'entrée pour le LDR3
#define LDR4_PIN A3 // sélectionnez la broche d'entrée pour le LDR4
int LDR1_Value; //variable pour stocker la valeur provenant du capteur LDR1
int LDR2_Value; //variable pour stocker la valeur provenant du capteur LDR2
int LDR3_Value; //variable pour stocker la valeur provenant du capteur LDR3
int LDR4_Value; //variable pour stocker la valeur provenant du capteur LDR4

/////////LDR1/////////
//LDR3//////////LDR2//
/////////LDR4/////////

int xValue = 0;  // Pour stocker la valeur de l'axe X
int yValue = 0;  // Pour stocker la valeur de l'axe Y
int Poservo1 = 90; //Position servo au démarrage
int Poservo2 = 90; //Position servo au démarrage

int tolerance = 30; //Tolérance de lumiére entre chaque capteur

void setup() {
  Serial.begin(9600);
  myservo1.attach(5);  // attache le servo sur la broche 5 à l'objet Servo
  myservo2.attach(6);  // attache le servo sur la broche 6 à l'objet Servo
  myservo1.write(Poservo1);
  myservo2.write(Poservo2);
}

void loop() {

  LDR1_Value = analogRead(LDR1_PIN);
  LDR2_Value = analogRead(LDR2_PIN);
  LDR3_Value = analogRead(LDR3_PIN);
  LDR4_Value = analogRead(LDR4_PIN);

  if (LDR1_Value < LDR4_Value - tolerance) {
    Poservo1 = Poservo1 - 1;
  }
  if (LDR4_Value < LDR1_Value - tolerance) {
    Poservo1 = Poservo1 + 1;
  }
  if (LDR3_Value < LDR2_Value - tolerance) {
    Poservo2 = Poservo2 + 1;
  }
  if (LDR2_Value < LDR3_Value - tolerance) {
    Poservo2 = Poservo2 - 1;
  }
  Poservo1 = constrain(Poservo1, 0, 180);
  Poservo2 = constrain(Poservo2, 0, 180);
  myservo1.write(Poservo1);
  myservo2.write(Poservo2);

  /*
  Serial.print("LDR1 : ");
  Serial.println(LDR1_Value);
  Serial.print("LDR2 : ");
  Serial.println(LDR2_Value);
  Serial.print("LDR3 : ");
  Serial.println(LDR3_Value);
  Serial.print("LDR4 : ");
  Serial.println(LDR4_Value);
  */
  
  delay(20);
}