#include <DistanceSensor.h>
#include <Servo.h>.
int Poservo1 = 0;   //Position servo au démarrage
int Poservo2 = 10;  //Position servo au démarrage
Servo myservo1;     // créer un objet Servo pour contrôler un servo
Servo myservo2;     // créer un objet Servo pour contrôler un servo
constexpr int TrigPin = 10;
constexpr int EchoPin = 11;
int distance;
int positionservo = 10;
int sens;


DistanceSensor<TrigPin, EchoPin> sensor;

unsigned long previousMillis = 0;
int interval = 20;

void setup() {
  sensor.begin();
  Serial.begin(9600);
  myservo1.attach(5);
  myservo2.attach(6);
  myservo1.write(Poservo1);
  myservo2.write(Poservo2);
}

void loop() {
  int sensorValue = analogRead(A0);
  interval = map(sensorValue, 0, 1024, 8, 60);

  unsigned long currentMillis = millis();
  if (currentMillis - previousMillis >= interval) {
    previousMillis = currentMillis;
    if (positionservo < 170 && sens == 0) {
      positionservo = positionservo + 1;
      myservo2.write(positionservo);
      print();
    }
    if (positionservo == 170 && sens == 0) {
      sens = 1;
    }
    if (positionservo > 10 && sens == 1) {
      positionservo = positionservo - 1;
      myservo2.write(positionservo);
      print();
    }
    if (positionservo == 10 && sens == 1) {
      sens = 0;
    }
  }

  int result = sensor.tick();
  // tick() retunrs NREADY if not ready, or
  // ERR on error (like timeout)
  if (result == sensor.NREADY) return;

  if (result == sensor.ERR) {
    result = 0;
    return;
  } else {
    distance = result;
  }
}

void print() {
  Serial.print(positionservo);
  Serial.print(",");
  Serial.print(distance);
  Serial.print(".");
}
