#define sensorPin 6 // Pin ou est branché capteur tactile
int colorStripLed;
int EtatBoutonTactile;

#include <Adafruit_NeoPixel.h>

#define PIN 3         // Pin ou est branché le Ring Led 
#define NUMPIXELS 12  // Nombre de LEDs du ruban
Adafruit_NeoPixel pixels(NUMPIXELS, PIN, NEO_GRB + NEO_KHZ800);
#define DELAYVAL 10  

void setup() {
  pinMode(sensorPin, INPUT);
  pixels.begin();  
  pixels.clear(); 
}

void loop() {
  int EtatBt = digitalRead(sensorPin);

  if (EtatBt == LOW && EtatBoutonTactile == 0) {
    EtatBoutonTactile = 1;
    colorStripLed = !colorStripLed;
    pixels.clear();  
  }
  if (EtatBt == HIGH) {
    EtatBoutonTactile = 0;
  }

  if (colorStripLed == 0) {
    for (int i = 0; i < NUMPIXELS; i++) {  
      pixels.setPixelColor(i, pixels.Color(255, 0, 0));
      pixels.show();    
      delay(DELAYVAL);  
    }
  }
  if (colorStripLed == 1) {
    for (int i = 0; i < NUMPIXELS; i++) {  
      pixels.setPixelColor(i, pixels.Color(0, 0, 255));
      pixels.show();    
      delay(DELAYVAL);  
    }
  }
}
