#include <Servo.h>
Servo myservo1;  // créer un objet Servo pour contrôler un servo
Servo myservo2;  // créer un objet Servo pour contrôler un servo
#define VRX_PIN A0  // Broche Arduino connectée à la broche VRX
#define VRY_PIN A1  // Broche Arduino connectée à la broche VRY
#define SW_PIN 2    // Broche Arduino connectée à la broche SW
int xValue = 0;     // Pour stocker la valeur de l'axe X
int xValueCentre = 0;
int yValue = 0;  // Pour stocker la valeur de l'axe Y
int yValueCentre = 0;
int SWValue = 0;  // Pour stocker la valeur du bouton SW
int Poservo1 = 90;
int Poservo2 = 90;
unsigned long previousMillis = 0;
int interval = 1000;

void setup() {
  Serial.begin(9600);
  // Déclare le bouton SW en entrée et on Active
  // la résistance de rappel interne
  pinMode(SW_PIN, INPUT_PULLUP);
  myservo1.attach(5);  // attache le servo sur la broche 5 à l'objet Servo
  myservo2.attach(6);  // attache le servo sur la broche 5 à l'objet Servo
  //On lance une procédure pour enregistrer la valeur des joysticks au repos.
  Serial.println("Ne pas toucher le Joystick initialisation");
  int var = 0;
    while (var < 6) {
      delay(500);
      var++;
      Serial.print(".");
    }
  xValue = analogRead(VRX_PIN);
  yValue = analogRead(VRY_PIN);
  xValueCentre = xValue;
  yValueCentre = yValue;
  Serial.println("Initialisation terminer");
  Serial.print("xValueCentre = ");
  Serial.println(xValueCentre);
  Serial.print("yValueCentre = ");
  Serial.println(yValueCentre);
  myservo1.write(Poservo1);  
  myservo2.write(Poservo2);  
  delay(2000);
}

void loop() {
  unsigned long currentMillis = millis();
  // lire les valeurs analogiques X et Y
  xValue = analogRead(VRX_PIN);
  yValue = analogRead(VRY_PIN);
  // lire la valeur digital du bouton SW
  SWValue = digitalRead(SW_PIN);

  if (xValue > xValueCentre + 20) {
    interval = map(xValue, xValueCentre + 10, 1024, 600, 1);
    if (currentMillis - previousMillis >= interval) {
      previousMillis = currentMillis;
      Poservo1 = Poservo1 + 1;
    }
  }
  if (xValue < xValueCentre - 20) {
    interval = map(xValue, xValueCentre - 10, 0, 600, 1);
    if (currentMillis - previousMillis >= interval) {
      previousMillis = currentMillis;
      Poservo1 = Poservo1 - 1;
    }
  }
  Poservo1 = constrain(Poservo1, 0, 180);

  if (yValue > yValueCentre + 20) {
    interval = map(yValue, yValueCentre + 10, 1024, 600, 1);
    if (currentMillis - previousMillis >= interval) {
      previousMillis = currentMillis;
      Poservo2 = Poservo2 + 1;
    }
  }
  if (yValue < yValueCentre - 20) {
    interval = map(yValue, yValueCentre - 10, 0, 600, 1);
    if (currentMillis - previousMillis >= interval) {
      previousMillis = currentMillis;
      Poservo2 = Poservo2 - 1;
    }
  }
  Poservo2 = constrain(Poservo2, 0, 180);

  myservo1.write(Poservo1);  // définit la position du servo en fonction de la valeur mise à l'échelle
  myservo2.write(Poservo2);  // définit la position du servo en fonction de la valeur mise à l'échelle
}
