const int TimeEchantillon = 50;  // Largeur de la fenêtre d'échantillon en mS (50 mS = 20 Hz)
int const MAX4466_PIN = A5;      // Broche de sortie du MAX4466 à A5
unsigned int echantillon;


void setup() {
  Serial.begin(9600);
}

void loop() {
  unsigned long startMillis = millis();  // Début de la fenêtre d'échantillon
  unsigned int niveaucrete = 0;          // niveau crête à crête

  unsigned int echantillonMax = 0;
  unsigned int echantillonMin = 1024;

  // collecter des données pendant 50 ms, puis tracer les données
  while (millis() - startMillis < TimeEchantillon) {
    echantillon = analogRead(MAX4466_PIN);
    if (echantillon < 1024)  // rejeter les lectures erronées
    {
      if (echantillon > echantillonMax) {
        echantillonMax = echantillon;  // enregistrez uniquement les niveaux maximum
      } else if (echantillon < echantillonMin) {
        echantillonMin = echantillon;  // enregistrez uniquement les niveaux minimun
      }
    }
  }
  niveaucrete = echantillonMax - echantillonMin;  // max - min = amplitude crête-crête
  Serial.println(niveaucrete);
}